/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.ParticleBuilder;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityRemnant
extends EntityMob {
    private static final DataParameter<Integer> ELEMENT = EntityDataManager.func_187226_a(EntityRemnant.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityRemnant.class, (DataSerializer)DataSerializers.field_187198_h);
    private ResourceLocation lootTable;
    @Nullable
    private BlockPos boundOrigin;

    public EntityRemnant(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70765_h = new AIMoveControl(this);
        this.field_70728_aV = 8;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ELEMENT, (Object)1);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityRemnant.class}));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setElement(Element.values()[1 + this.field_70146_Z.nextInt(Element.values().length - 1)]);
        this.setBoundOrigin(new BlockPos((Entity)this));
        return super.func_180482_a(difficulty, livingdata);
    }

    public Element getElement() {
        return Element.values()[(Integer)this.field_70180_af.func_187225_a(ELEMENT)];
    }

    public void setElement(Element element) {
        this.field_70180_af.func_187227_b(ELEMENT, (Object)element.ordinal());
        this.lootTable = new ResourceLocation("ebwizardry", "entities/remnant/" + element.func_176610_l());
    }

    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOriginIn) {
        this.boundOrigin = boundOriginIn;
    }

    protected boolean func_70814_o() {
        return true;
    }

    public float func_180484_a(BlockPos pos) {
        return 1.0f;
    }

    protected float func_70672_c(DamageSource source, float damage) {
        damage = super.func_70672_c(source, damage);
        if (source.func_82725_o()) {
            damage *= 0.25f;
        }
        return damage;
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        if (this.field_70170_p.field_72995_K) {
            Vec3d centre = this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0);
            int[] colours = BlockReceptacle.PARTICLE_COLOURS.get((Object)this.getElement());
            if (this.field_70146_Z.nextInt(10) == 0) {
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).entity((Entity)this).pos(0.0, this.field_70131_O / 2.0f, 0.0).scale(this.field_70130_N).time(48).clr(colours[0]).spawn(this.field_70170_p);
            }
            double r = this.field_70130_N / 3.0f;
            double x = r * (this.field_70146_Z.nextDouble() * 2.0 - 1.0);
            double y = r * (this.field_70146_Z.nextDouble() * 2.0 - 1.0);
            double z = r * (this.field_70146_Z.nextDouble() * 2.0 - 1.0);
            if (this.field_70725_aQ > 0) {
                for (int i = 0; i < 8; ++i) {
                    ParticleBuilder.create(ParticleBuilder.Type.DUST, this.field_70146_Z, centre.field_72450_a + x, centre.field_72448_b + y, centre.field_72449_c + z, 0.1, true).time(12).clr(colours[1]).fade(colours[2]).spawn(this.field_70170_p);
                }
            } else {
                ParticleBuilder.create(ParticleBuilder.Type.DUST).pos(centre.field_72450_a + x, centre.field_72448_b + y, centre.field_72449_c + z).vel(x * -0.03, 0.02, z * -0.03).time(24 + this.field_70146_Z.nextInt(8)).clr(colours[1]).fade(colours[2]).spawn(this.field_70170_p);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return WizardrySounds.ENTITY_REMNANT_AMBIENT;
    }

    protected SoundEvent func_184615_bR() {
        return WizardrySounds.ENTITY_REMNANT_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return WizardrySounds.ENTITY_REMNANT_HURT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.lootTable;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setElement(Element.values()[nbt.func_74762_e("Element")]);
        if (nbt.func_74764_b("BoundOrigin")) {
            this.boundOrigin = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("BoundOrigin"));
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Element", this.getElement().ordinal());
        if (this.boundOrigin != null) {
            nbt.func_74782_a("BoundOrigin", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.boundOrigin));
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityRemnant.this.func_70605_aq().func_75640_a() && EntityRemnant.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = EntityRemnant.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)EntityRemnant.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityRemnant.this.field_70146_Z.nextInt(15) - 7, EntityRemnant.this.field_70146_Z.nextInt(11) - 5, EntityRemnant.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityRemnant.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityRemnant.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityRemnant.this.func_70638_az() != null) break;
                EntityRemnant.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityRemnant host) {
            super((EntityLiving)host);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityRemnant.this.field_70165_t;
                double d1 = this.field_75647_c - EntityRemnant.this.field_70163_u;
                double d2 = this.field_75644_d - EntityRemnant.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityRemnant.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityRemnant.this.field_70159_w *= 0.5;
                    EntityRemnant.this.field_70181_x *= 0.5;
                    EntityRemnant.this.field_70179_y *= 0.5;
                } else {
                    EntityRemnant.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityRemnant.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityRemnant.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityRemnant.this.func_70638_az() == null) {
                        EntityRemnant.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityRemnant.this.field_70159_w, (double)EntityRemnant.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityRemnant.this.func_70638_az().field_70165_t - EntityRemnant.this.field_70165_t;
                        double d5 = EntityRemnant.this.func_70638_az().field_70161_v - EntityRemnant.this.field_70161_v;
                        EntityRemnant.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                    EntityRemnant.this.field_70761_aq = EntityRemnant.this.field_70177_z;
                }
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityRemnant.this.func_70638_az() != null && !EntityRemnant.this.func_70605_aq().func_75640_a() && EntityRemnant.this.field_70146_Z.nextInt(7) == 0) {
                return EntityRemnant.this.func_70068_e((Entity)EntityRemnant.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityRemnant.this.func_70605_aq().func_75640_a() && EntityRemnant.this.isAttacking() && EntityRemnant.this.func_70638_az() != null && EntityRemnant.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityRemnant.this.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            EntityRemnant.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            EntityRemnant.this.setAttacking(true);
        }

        public void func_75251_c() {
            EntityRemnant.this.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = EntityRemnant.this.func_70638_az();
            if (EntityRemnant.this.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ())) {
                EntityRemnant.this.func_70652_k((Entity)entitylivingbase);
                EntityRemnant.this.setAttacking(false);
            } else {
                double d0 = EntityRemnant.this.func_70068_e((Entity)entitylivingbase);
                if (d0 < 9.0) {
                    Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                    EntityRemnant.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                }
            }
        }
    }
}

