/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.integration.jei;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.enchantment.Imbuement;
import electroblob.wizardry.integration.jei.ArcaneWorkbenchRecipeCategory;
import electroblob.wizardry.integration.jei.ArcaneWorkbenchTransferHandler;
import electroblob.wizardry.integration.jei.ImbuementAltarRecipeCategory;
import electroblob.wizardry.item.IConjuredItem;
import electroblob.wizardry.item.ItemArcaneTome;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWandUpgrade;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryEnchantments;
import electroblob.wizardry.registry.WizardryItems;
import java.util.Arrays;
import java.util.Locale;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

@JEIPlugin
public class WizardryJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (!Wizardry.settings.jeiIntegration) {
            return;
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new ArcaneWorkbenchRecipeCategory(registry)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ImbuementAltarRecipeCategory(registry)});
    }

    public void register(IModRegistry registry) {
        if (!Wizardry.settings.jeiIntegration) {
            return;
        }
        registry.addRecipeCatalyst((Object)new ItemStack(WizardryBlocks.arcane_workbench), new String[]{"ebwizardry:arcane_workbench"});
        registry.addRecipes(ArcaneWorkbenchRecipeCategory.generateRecipes(), "ebwizardry:arcane_workbench");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new ArcaneWorkbenchTransferHandler());
        registry.addRecipeCatalyst((Object)new ItemStack(WizardryBlocks.imbuement_altar), new String[]{"ebwizardry:imbuement_altar"});
        registry.addRecipes(ImbuementAltarRecipeCategory.generateRecipes(), "ebwizardry:imbuement_altar");
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof IConjuredItem)) continue;
            blacklist.addIngredientToBlacklist((Object)new ItemStack(item));
        }
        for (Enchantment enchantment : Enchantment.field_185264_b) {
            if (!(enchantment instanceof Imbuement)) continue;
            for (int level = enchantment.func_77319_d(); level <= enchantment.func_77325_b(); ++level) {
                blacklist.addIngredientToBlacklist((Object)new EnchantmentData(enchantment, level));
            }
        }
        WizardryJEIPlugin.addItemInfo(registry, WizardryItems.magic_crystal);
        WizardryJEIPlugin.addItemInfo(registry, WizardryItems.wizard_handbook);
        WizardryJEIPlugin.addItemInfo(registry, WizardryItems.crystal_shard);
        WizardryJEIPlugin.addItemInfo(registry, WizardryItems.grand_crystal);
        WizardryJEIPlugin.addItemInfo(registry, WizardryItems.identification_scroll, ".desc_extended");
        WizardryJEIPlugin.addItemInfo(registry, WizardryItems.spell_book);
        WizardryJEIPlugin.addItemInfo(registry, WizardryItems.scroll);
        WizardryJEIPlugin.addItemInfo(registry, WizardryItems.armour_upgrade, ".desc_extended");
        WizardryJEIPlugin.addItemInfo(registry, WizardryItems.purifying_elixir, ".desc_extended");
        WizardryJEIPlugin.addItemInfo(registry, WizardryItems.astral_diamond);
        WizardryJEIPlugin.addItemInfo(registry, WizardryItems.ruined_spell_book);
        for (Item item : Item.field_150901_e) {
            if (item instanceof ItemArtefact) {
                ItemStack stack = new ItemStack(item);
                registry.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new String[]{"item.ebwizardry:" + ((ItemArtefact)item).getType().toString().toLowerCase(Locale.ROOT) + ".generic.desc"});
                continue;
            }
            if (!(item instanceof ItemWandUpgrade) && !(item instanceof ItemArcaneTome)) continue;
            NonNullList subItems = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), subItems);
            for (ItemStack stack : subItems) {
                registry.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new String[]{"item.ebwizardry:wand_upgrade.generic.desc"});
            }
        }
        WizardryJEIPlugin.addEnchantmentInfo(registry, WizardryEnchantments.magic_protection);
        WizardryJEIPlugin.addEnchantmentInfo(registry, WizardryEnchantments.frost_protection);
        WizardryJEIPlugin.addEnchantmentInfo(registry, WizardryEnchantments.shock_protection);
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        if (!Wizardry.settings.jeiIntegration) {
            return;
        }
    }

    private static void addItemInfo(IModRegistry registry, Item item) {
        WizardryJEIPlugin.addItemInfo(registry, item, ".desc");
    }

    private static void addItemInfo(IModRegistry registry, Item item, String ... suffixes) {
        NonNullList subItems = NonNullList.func_191196_a();
        item.func_150895_a(item.func_77640_w(), subItems);
        for (ItemStack stack : subItems) {
            WizardryJEIPlugin.addItemInfo(registry, stack, suffixes);
        }
    }

    private static void addItemInfo(IModRegistry registry, ItemStack stack, String ... suffixes) {
        String prefix = stack.func_77973_b().func_77667_c(stack);
        String[] keys = (String[])Arrays.stream(suffixes).map(s -> prefix + s).toArray(String[]::new);
        registry.addIngredientInfo((Object)stack, VanillaTypes.ITEM, keys);
    }

    private static void addEnchantmentInfo(IModRegistry registry, Enchantment enchantment) {
        WizardryJEIPlugin.addEnchantmentInfo(registry, enchantment, ".desc");
    }

    private static void addEnchantmentInfo(IModRegistry registry, Enchantment enchantment, String ... suffixes) {
        for (int level = enchantment.func_77319_d(); level <= enchantment.func_77325_b(); ++level) {
            WizardryJEIPlugin.addEnchantmentInfo(registry, new EnchantmentData(enchantment, level), suffixes);
        }
    }

    private static void addEnchantmentInfo(IModRegistry registry, EnchantmentData data, String ... suffixes) {
        String prefix = data.field_76302_b.func_77320_a().replace(":", ".");
        String[] keys = (String[])Arrays.stream(suffixes).map(s -> prefix + s).toArray(String[]::new);
        registry.addIngredientInfo((Object)data, VanillaTypes.ENCHANT, keys);
    }
}

