/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public interface IManaStoringItem {
    public int getMana(ItemStack var1);

    public void setMana(ItemStack var1, int var2);

    public int getManaCapacity(ItemStack var1);

    default public boolean showManaInWorkbench(EntityPlayer player, ItemStack stack) {
        return true;
    }

    default public void consumeMana(ItemStack stack, int mana, @Nullable EntityLivingBase wielder) {
        if (wielder instanceof EntityPlayer && ((EntityPlayer)wielder).func_184812_l_()) {
            return;
        }
        this.setMana(stack, Math.max(this.getMana(stack) - mana, 0));
    }

    default public void rechargeMana(ItemStack stack, int mana) {
        this.setMana(stack, Math.min(this.getMana(stack) + mana, this.getManaCapacity(stack)));
    }

    default public boolean isManaFull(ItemStack stack) {
        return this.getMana(stack) == this.getManaCapacity(stack);
    }

    default public boolean isManaEmpty(ItemStack stack) {
        return this.getMana(stack) == 0;
    }

    default public float getFullness(ItemStack stack) {
        return (float)this.getMana(stack) / (float)this.getManaCapacity(stack);
    }
}

