/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import com.google.common.collect.Multimap;
import electroblob.wizardry.item.IConjuredItem;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.MagicDamage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlamingAxe
extends ItemAxe
implements IConjuredItem {
    private EnumRarity rarity = EnumRarity.COMMON;

    public ItemFlamingAxe(Item.ToolMaterial material) {
        super(material, 8.0f, -3.0f);
        this.func_77656_e(1200);
        this.setNoRepair();
        this.func_77637_a(null);
        this.addAnimationPropertyOverrides();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(POTENCY_MODIFIER, "Potency modifier", (double)(IConjuredItem.getDamageMultiplier(stack) - 1.0f), 2));
        }
        return multimap;
    }

    public Item setRarity(EnumRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMaxDamageFromNBT(stack, Spells.flaming_axe);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return IConjuredItem.getTimerBarColour(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!(oldStack.func_190926_b() && newStack.func_190926_b() || oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        int damage = stack.func_77952_i();
        if (damage > stack.func_77958_k()) {
            InventoryUtils.replaceItemInInventory(entity, slot, stack, ItemStack.field_190927_a);
        }
        stack.func_77964_b(damage + 1);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        this.field_77865_bY = Spells.flaming_axe.getProperty("damage").floatValue();
        return super.func_111205_h(equipmentSlot);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
        if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)target)) {
            target.func_70015_d(Spells.flaming_axe.getProperty("burn_duration").intValue());
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack par2ItemStack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return false;
    }
}

