/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.InventoryUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemManaFlask
extends Item {
    public final Size size;

    public ItemManaFlask(Size size) {
        this.size = size;
        this.func_77637_a(WizardryTabs.WIZARDRY);
        this.func_77625_d(16);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.size.rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item.ebwizardry:mana_flask.desc", this.size.capacity);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack flask = player.func_184586_b(hand);
        List<ItemStack> stacks = InventoryUtils.getPrioritisedHotbarAndOffhand(player);
        stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_70460_b);
        ItemStack toCharge = stacks.stream().filter(s -> s.func_77973_b() instanceof IManaStoringItem && !((IManaStoringItem)s.func_77973_b()).isManaFull((ItemStack)s)).min(Comparator.comparingDouble(s -> ((IManaStoringItem)s.func_77973_b()).getFullness((ItemStack)s))).orElse(null);
        if (toCharge != null) {
            ((IManaStoringItem)toCharge.func_77973_b()).rechargeMana(toCharge, this.size.capacity);
            EntityUtils.playSoundAtPlayer(player, WizardrySounds.ITEM_MANA_FLASK_USE, 1.0f, 1.0f);
            EntityUtils.playSoundAtPlayer(player, WizardrySounds.ITEM_MANA_FLASK_RECHARGE, 0.7f, 1.1f);
            if (!player.func_184812_l_()) {
                flask.func_190918_g(1);
            }
            player.func_184811_cZ().func_185145_a((Item)this, 20);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)flask);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)flask);
    }

    public static enum Size {
        SMALL(75, EnumRarity.COMMON),
        MEDIUM(700, EnumRarity.COMMON),
        LARGE(1400, EnumRarity.RARE);

        public int capacity;
        public EnumRarity rarity;

        private Size(int capacity, EnumRarity rarity) {
            this.capacity = capacity;
            this.rarity = rarity;
        }
    }
}

