/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import com.google.common.collect.Multimap;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryRecipes;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.SpellProperties;
import electroblob.wizardry.util.WandHelper;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemWand
extends Item
implements IWorkbenchItem,
ISpellCastingItem,
IManaStoringItem {
    public static final int BASE_SPELL_SLOTS = 5;
    private static final int CONTINUOUS_TRACKING_INTERVAL = 20;
    private static final float ELEMENTAL_PROGRESSION_MODIFIER = 1.2f;
    private static final float DISCOVERY_PROGRESSION_MODIFIER = 5.0f;
    private static final float SECOND_TIME_PROGRESSION_MODIFIER = 1.5f;
    private static final float MAX_PROGRESSION_REDUCTION = 0.75f;
    public Tier tier;
    public Element element;

    public ItemWand(Tier tier, Element element) {
        this.func_77625_d(1);
        this.func_77637_a(WizardryTabs.GEAR);
        this.tier = tier;
        this.element = element;
        this.func_77656_e(this.tier.maxCharge);
        WizardryRecipes.addToManaFlaskCharging(this);
        this.func_185043_a(new ResourceLocation("pointing"), (s, w, e) -> e != null && e.func_184607_cu() == s && (s.func_77975_n() == SpellActions.POINT || s.func_77975_n() == SpellActions.POINT_UP || s.func_77975_n() == SpellActions.POINT_DOWN || s.func_77975_n() == SpellActions.GRAPPLE || s.func_77975_n() == SpellActions.SUMMON) ? 1.0f : 0.0f);
    }

    @Override
    public Spell getCurrentSpell(ItemStack stack) {
        return WandHelper.getCurrentSpell(stack);
    }

    @Override
    public Spell getNextSpell(ItemStack stack) {
        return WandHelper.getNextSpell(stack);
    }

    @Override
    public Spell getPreviousSpell(ItemStack stack) {
        return WandHelper.getPreviousSpell(stack);
    }

    @Override
    public Spell[] getSpells(ItemStack stack) {
        return WandHelper.getSpells(stack);
    }

    @Override
    public void selectNextSpell(ItemStack stack) {
        WandHelper.selectNextSpell(stack);
    }

    @Override
    public void selectPreviousSpell(ItemStack stack) {
        WandHelper.selectPreviousSpell(stack);
    }

    @Override
    public boolean selectSpell(ItemStack stack, int index) {
        return WandHelper.selectSpell(stack, index);
    }

    @Override
    public int getCurrentCooldown(ItemStack stack) {
        return WandHelper.getCurrentCooldown(stack);
    }

    @Override
    public int getCurrentMaxCooldown(ItemStack stack) {
        return WandHelper.getCurrentMaxCooldown(stack);
    }

    @Override
    public boolean showSpellHUD(EntityPlayer player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    @Override
    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    @Override
    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    @Override
    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return Wizardry.proxy.getFontRenderer(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return !Wizardry.settings.legacyWandLevelling && this.tier.level < Tier.MASTER.level && WandHelper.getProgression(stack) >= this.tier.next().getProgression();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return DrawingUtils.mix(16747518, 9318116, (float)this.getDurabilityForDisplay(stack));
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)((float)super.getMaxDamage(stack) * (1.0f + 0.15f * (float)WandHelper.getUpgradeLevel(stack, WizardryItems.storage_upgrade)) + 0.5f);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        this.setMana(stack, 0);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        WandHelper.decrementCooldowns(stack);
        if (!world.field_72995_K && !this.isManaFull(stack) && world.func_82737_E() % 50L == 0L) {
            this.rechargeMana(stack, WandHelper.getUpgradeLevel(stack, WizardryItems.condenser_upgrade));
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        int level;
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && (level = WandHelper.getUpgradeLevel(stack, WizardryItems.melee_upgrade)) > 0 && !this.isManaEmpty(stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Melee upgrade modifier", (double)(2 * level), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Melee upgrade modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
        int level = WandHelper.getUpgradeLevel(stack, WizardryItems.melee_upgrade);
        int mana = this.getMana(stack);
        if (level > 0 && mana > 0) {
            this.consumeMana(stack, level * 4, wielder);
        }
        return true;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return WandHelper.getUpgradeLevel(stack, WizardryItems.melee_upgrade) == 0;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return true;
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return false;
        }
        return super.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!(oldStack.func_190926_b() && newStack.func_190926_b() || oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged || !(oldStack.func_77973_b() instanceof ItemWand) || !(newStack.func_77973_b() instanceof ItemWand) || WandHelper.getCurrentSpell(oldStack) != WandHelper.getCurrentSpell(newStack))) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return WandHelper.getCurrentSpell((ItemStack)itemstack).action;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> text, ITooltipFlag advanced) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (this.element != null) {
            text.add(Wizardry.proxy.translate("item.ebwizardry:wand.buff", new Style().func_150238_a(TextFormatting.DARK_GRAY), new Object[]{(int)((float)(this.tier.level + 1) * 0.15f * 100.0f + 0.5f), this.element.getDisplayName()}));
        }
        Spell spell = WandHelper.getCurrentSpell(stack);
        boolean discovered = true;
        if (Wizardry.settings.discoveryMode && !player.func_184812_l_() && WizardData.get((EntityPlayer)player) != null && !WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell)) {
            discovered = false;
        }
        text.add(Wizardry.proxy.translate("item.ebwizardry:wand.spell", new Style().func_150238_a(TextFormatting.GRAY), new Object[]{discovered ? spell.getDisplayNameWithFormatting() : "#" + TextFormatting.BLUE + SpellGlyphData.getGlyphName(spell, player.field_70170_p)}));
        if (advanced.func_194127_a()) {
            text.add(Wizardry.proxy.translate("item.ebwizardry:wand.mana", new Style().func_150238_a(TextFormatting.BLUE), new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
            text.add(Wizardry.proxy.translate("item.ebwizardry:wand.progression", new Style().func_150238_a(TextFormatting.GRAY), new Object[]{WandHelper.getProgression(stack), this.tier.level < Tier.MASTER.level ? this.tier.next().getProgression() : 0}));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return (this.element == null ? "" : this.element.getFormattingCode()) + super.func_77653_i(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        SpellModifiers modifiers;
        ItemStack stack = player.func_184586_b(hand);
        if (this.selectMinionTarget(player, world)) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        Spell spell = WandHelper.getCurrentSpell(stack);
        if (this.canCast(stack, spell, player, hand, 0, modifiers = this.calculateModifiers(stack, player, spell))) {
            int chargeup = (int)((float)spell.getChargeup() * modifiers.get("chargeup"));
            if (spell.isContinuous || chargeup > 0) {
                if (!player.func_184587_cr()) {
                    player.func_184598_c(hand);
                    if (WizardData.get(player) != null) {
                        WizardData.get((EntityPlayer)player).itemCastingModifiers = modifiers;
                    }
                    if (chargeup > 0 && world.field_72995_K) {
                        Wizardry.proxy.playChargeupSound((EntityLivingBase)player);
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            } else if (this.cast(stack, spell, player, hand, 0, modifiers)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            Spell spell = WandHelper.getCurrentSpell(stack);
            SpellModifiers modifiers = WizardData.get(player) != null ? WizardData.get((EntityPlayer)player).itemCastingModifiers : this.calculateModifiers(stack, (EntityPlayer)user, spell);
            int useTick = stack.func_77988_m() - count;
            int chargeup = (int)((float)spell.getChargeup() * modifiers.get("chargeup"));
            if (spell.isContinuous) {
                if (useTick >= chargeup) {
                    int castingTick = useTick - chargeup;
                    if (castingTick == 0 || this.canCast(stack, spell, player, player.func_184600_cs(), castingTick, modifiers)) {
                        this.cast(stack, spell, player, player.func_184600_cs(), castingTick, modifiers);
                    } else {
                        player.func_184597_cx();
                    }
                }
            } else if (chargeup > 0 && useTick == chargeup) {
                this.cast(stack, spell, player, player.func_184600_cs(), 0, modifiers);
            }
        }
    }

    @Override
    public boolean canCast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        if (castingTick == 0 ? MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.WAND, spell, (EntityLivingBase)caster, modifiers)) : MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.WAND, spell, (EntityLivingBase)caster, modifiers, castingTick))) {
            return false;
        }
        int cost = (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
        if (spell.isContinuous) {
            cost = ItemWand.getDistributedCost(cost, castingTick);
        }
        return cost <= this.getMana(stack) && spell.getTier().level <= this.tier.level && (WandHelper.getCurrentCooldown(stack) == 0 || caster.func_184812_l_());
    }

    @Override
    public boolean cast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        World world = caster.field_70170_p;
        if (world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
            return false;
        }
        if (spell.cast(world, caster, hand, castingTick, modifiers)) {
            if (castingTick == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.WAND, spell, (EntityLivingBase)caster, modifiers));
            }
            if (!world.field_72995_K) {
                if (!spell.isContinuous && spell.requiresPacket()) {
                    PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), hand, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
                }
                int cost = (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
                if (spell.isContinuous) {
                    cost = ItemWand.getDistributedCost(cost, castingTick);
                }
                if (cost > 0) {
                    this.consumeMana(stack, cost, (EntityLivingBase)caster);
                }
            }
            caster.func_184598_c(hand);
            if (!spell.isContinuous && !caster.func_184812_l_()) {
                WandHelper.setCurrentCooldown(stack, (int)((float)spell.getCooldown() * modifiers.get(WizardryItems.cooldown_upgrade)));
            }
            if (this.tier.level < Tier.MASTER.level && castingTick % 20 == 0) {
                int progression = (int)((float)spell.getCost() * modifiers.get("progression"));
                WandHelper.addProgression(stack, progression);
                if (!Wizardry.settings.legacyWandLevelling) {
                    Tier nextTier = this.tier.next();
                    int excess = WandHelper.getProgression(stack) - nextTier.getProgression();
                    if (excess >= 0 && excess < progression) {
                        caster.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.25f, 1.0f);
                        WizardryAdvancementTriggers.wand_levelup.triggerFor(caster);
                        if (!world.field_72995_K) {
                            caster.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:wand.levelup", new Object[]{this.func_77653_i(stack), nextTier.getNameForTranslationFormatted()}));
                        }
                    }
                }
                WizardData.get(caster).trackRecentSpell(spell);
            }
            return true;
        }
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase user, int timeLeft) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            Spell spell = WandHelper.getCurrentSpell(stack);
            SpellModifiers modifiers = WizardData.get(player) != null ? WizardData.get((EntityPlayer)player).itemCastingModifiers : this.calculateModifiers(stack, (EntityPlayer)user, spell);
            int castingTick = stack.func_77988_m() - timeLeft;
            int cost = ItemWand.getDistributedCost((int)((float)spell.getCost() * modifiers.get("cost") + 0.1f), castingTick);
            if (spell.isContinuous && spell.getTier().level <= this.tier.level && cost <= this.getMana(stack)) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Finish(SpellCastEvent.Source.WAND, spell, (EntityLivingBase)player, modifiers, castingTick));
                spell.finishCasting(world, (EntityLivingBase)player, Double.NaN, Double.NaN, Double.NaN, null, castingTick, modifiers);
                if (!player.func_184812_l_()) {
                    WandHelper.setCurrentCooldown(stack, (int)((float)spell.getCooldown() * modifiers.get(WizardryItems.cooldown_upgrade)));
                }
            }
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (player.func_70093_af() && entity instanceof EntityPlayer && WizardData.get(player) != null) {
            String string;
            String string2 = string = WizardData.get(player).toggleAlly((EntityPlayer)entity) ? "item.ebwizardry:wand.addally" : "item.ebwizardry:wand.removeally";
            if (!player.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(string, new Object[]{entity.func_70005_c_()}));
            }
            return true;
        }
        return false;
    }

    protected static int getDistributedCost(int cost, int castingTick) {
        int partialCost = castingTick % 20 == 0 ? cost / 2 + cost % 2 : (castingTick % 10 == 0 ? cost / 2 : 0);
        return partialCost;
    }

    public SpellModifiers calculateModifiers(ItemStack stack, EntityPlayer player, Spell spell) {
        SpellModifiers modifiers = new SpellModifiers();
        int level = WandHelper.getUpgradeLevel(stack, WizardryItems.range_upgrade);
        if (level > 0) {
            modifiers.set(WizardryItems.range_upgrade, 1.0f + (float)level * 0.25f, true);
        }
        if ((level = WandHelper.getUpgradeLevel(stack, WizardryItems.duration_upgrade)) > 0) {
            modifiers.set(WizardryItems.duration_upgrade, 1.0f + (float)level * 0.25f, false);
        }
        if ((level = WandHelper.getUpgradeLevel(stack, WizardryItems.blast_upgrade)) > 0) {
            modifiers.set(WizardryItems.blast_upgrade, 1.0f + (float)level * 0.25f, true);
        }
        if ((level = WandHelper.getUpgradeLevel(stack, WizardryItems.cooldown_upgrade)) > 0) {
            modifiers.set(WizardryItems.cooldown_upgrade, 1.0f - (float)level * 0.15f, true);
        }
        float progressionModifier = 1.0f - (float)WizardData.get(player).countRecentCasts(spell) / 5.0f * 0.75f;
        if (this.element == spell.getElement()) {
            modifiers.set("potency", 1.0f + (float)(this.tier.level + 1) * 0.15f, true);
            progressionModifier *= 1.2f;
        }
        if (WizardData.get(player) != null) {
            if (!WizardData.get(player).hasSpellBeenDiscovered(spell)) {
                progressionModifier *= 5.0f;
            }
            if (!WizardData.get(player).hasReachedTier(this.tier.next())) {
                progressionModifier *= 1.5f;
            }
        }
        modifiers.set("progression", progressionModifier, false);
        return modifiers;
    }

    private boolean selectMinionTarget(EntityPlayer player, World world) {
        RayTraceResult rayTrace = RayTracer.standardEntityRayTrace(world, (Entity)player, 16.0, false);
        if (rayTrace != null && EntityUtils.isLiving(rayTrace.field_72308_g)) {
            ISummonedCreature minion;
            EntityLivingBase entity = (EntityLivingBase)rayTrace.field_72308_g;
            if (player.func_70093_af() && WizardData.get(player) != null && WizardData.get((EntityPlayer)player).selectedMinion != null && (minion = (ISummonedCreature)WizardData.get((EntityPlayer)player).selectedMinion.get()) instanceof EntityLiving && minion != entity) {
                ((EntityLiving)minion).func_70624_b(entity);
                WizardData.get((EntityPlayer)player).selectedMinion = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSpellSlotCount(ItemStack stack) {
        return 5 + WandHelper.getUpgradeLevel(stack, WizardryItems.attunement_upgrade);
    }

    @Override
    public ItemStack applyUpgrade(@Nullable EntityPlayer player, ItemStack wand, ItemStack upgrade) {
        if (upgrade.func_77973_b() == WizardryItems.arcane_tome) {
            Tier tier = Tier.values()[upgrade.func_77952_i()];
            if ((player == null || player.func_184812_l_() || Wizardry.settings.legacyWandLevelling || WandHelper.getProgression(wand) >= tier.getProgression()) && tier == this.tier.next() && this.tier != Tier.MASTER) {
                if (Wizardry.settings.legacyWandLevelling) {
                    WandHelper.setProgression(wand, 0);
                } else {
                    WandHelper.setProgression(wand, WandHelper.getProgression(wand) - tier.getProgression());
                }
                if (player != null) {
                    WizardData.get(player).setTierReached(tier);
                }
                ItemStack newWand = new ItemStack(WizardryItems.getWand(tier, this.element));
                newWand.func_77982_d(wand.func_77978_p());
                ((IManaStoringItem)newWand.func_77973_b()).setMana(newWand, this.getMana(wand));
                upgrade.func_190918_g(1);
                return newWand;
            }
        } else if (WandHelper.isWandUpgrade(upgrade.func_77973_b())) {
            Item specialUpgrade = upgrade.func_77973_b();
            int maxUpgrades = this.tier.upgradeLimit;
            if (this.element == Element.MAGIC) {
                maxUpgrades += 3;
            }
            if (WandHelper.getTotalUpgrades(wand) < maxUpgrades && WandHelper.getUpgradeLevel(wand, specialUpgrade) < 3) {
                int prevMana = this.getMana(wand);
                WandHelper.applyUpgrade(wand, specialUpgrade);
                if (specialUpgrade == WizardryItems.storage_upgrade) {
                    this.setMana(wand, prevMana);
                } else if (specialUpgrade == WizardryItems.attunement_upgrade) {
                    int newSlotCount = 5 + WandHelper.getUpgradeLevel(wand, WizardryItems.attunement_upgrade);
                    Spell[] spells = WandHelper.getSpells(wand);
                    Spell[] newSpells = new Spell[newSlotCount];
                    for (int i = 0; i < newSpells.length; ++i) {
                        newSpells[i] = i < spells.length && spells[i] != null ? spells[i] : Spells.none;
                    }
                    WandHelper.setSpells(wand, newSpells);
                    int[] cooldowns = WandHelper.getCooldowns(wand);
                    int[] newCooldowns = new int[newSlotCount];
                    if (cooldowns.length > 0) {
                        System.arraycopy(cooldowns, 0, newCooldowns, 0, cooldowns.length);
                    }
                    WandHelper.setCooldowns(wand, newCooldowns);
                }
                upgrade.func_190918_g(1);
                if (player != null) {
                    WizardryAdvancementTriggers.special_upgrade.triggerFor(player);
                    if (WandHelper.getTotalUpgrades(wand) == Tier.MASTER.upgradeLimit) {
                        WizardryAdvancementTriggers.max_out_wand.triggerFor(player);
                    }
                }
            }
        }
        return wand;
    }

    @Override
    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        Spell[] spells;
        boolean changed = false;
        if (upgrade.func_75216_d()) {
            ItemStack original = centre.func_75211_c().func_77946_l();
            centre.func_75215_d(this.applyUpgrade(player, centre.func_75211_c(), upgrade.func_75211_c()));
            changed = ItemStack.func_77989_b((ItemStack)centre.func_75211_c(), (ItemStack)original);
        }
        if ((spells = WandHelper.getSpells(centre.func_75211_c())).length <= 0) {
            spells = new Spell[5];
        }
        for (int i = 0; i < spells.length; ++i) {
            if (spellBooks[i].func_75211_c() == ItemStack.field_190927_a) continue;
            Spell spell = Spell.byMetadata(spellBooks[i].func_75211_c().func_77952_i());
            if (spell.getTier().level > this.tier.level || spells[i] == spell || !spell.isEnabled(SpellProperties.Context.WANDS)) continue;
            spells[i] = spell;
            changed = true;
        }
        WandHelper.setSpells(centre.func_75211_c(), spells);
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            int manaPerItem = 100;
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.crystal_shard) {
                manaPerItem = 10;
            }
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.grand_crystal) {
                manaPerItem = 400;
            }
            if (crystals.func_75211_c().func_190916_E() * manaPerItem < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * manaPerItem);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / (double)manaPerItem));
            }
            changed = true;
        }
        return changed;
    }

    @SubscribeEvent
    public static void onAttackEntityEvent(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof IManaStoringItem) {
            int level = WandHelper.getUpgradeLevel(stack, WizardryItems.melee_upgrade);
            int mana = ((IManaStoringItem)stack.func_77973_b()).getMana(stack);
            if (level > 0 && mana > 0) {
                Random random = player.field_70170_p.field_73012_v;
                player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, WizardrySounds.ITEM_WAND_MELEE, SoundCategory.PLAYERS, 0.75f, 1.0f, false);
                if (player.field_70170_p.field_72995_K) {
                    Vec3d origin = player.func_174824_e(1.0f);
                    Vec3d hit = origin.func_178787_e(player.func_70040_Z().func_186678_a((double)player.func_70032_d(event.getTarget())));
                    Vec3d vec1 = player.func_70040_Z().func_178789_a(90.0f);
                    Vec3d vec2 = player.func_70040_Z().func_72431_c(vec1);
                    for (int i = 0; i < 15; ++i) {
                        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(hit).vel(vec1.func_186678_a((double)(random.nextFloat() * 0.3f - 0.15f)).func_178787_e(vec2.func_186678_a((double)(random.nextFloat() * 0.3f - 0.15f)))).clr(1.0f, 1.0f, 1.0f).fade(0.3f, 0.5f, 1.0f).time(8 + random.nextInt(4)).spawn(player.field_70170_p);
                    }
                }
            }
        }
    }
}

