/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.packet;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.inventory.ContainerArcaneWorkbench;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Possession;
import electroblob.wizardry.spell.Resurrection;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.SpellModifiers;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketControlInput
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                ItemStack wand = player.func_184614_ca();
                if (!(wand.func_77973_b() instanceof ISpellCastingItem)) {
                    wand = player.func_184592_cb();
                }
                switch (message.controlType) {
                    case APPLY_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerArcaneWorkbench)) {
                            Wizardry.logger.warn("Received a PacketControlInput, but the player that sent it was not currently using an arcane workbench. This should not happen!");
                            break;
                        }
                        ((ContainerArcaneWorkbench)player.field_71070_bA).onApplyButtonPressed((EntityPlayer)player);
                        break;
                    }
                    case NEXT_SPELL_KEY: {
                        if (!(wand.func_77973_b() instanceof ISpellCastingItem)) break;
                        ((ISpellCastingItem)wand.func_77973_b()).selectNextSpell(wand);
                        player.func_184597_cx();
                        break;
                    }
                    case PREVIOUS_SPELL_KEY: {
                        if (!(wand.func_77973_b() instanceof ISpellCastingItem)) break;
                        ((ISpellCastingItem)wand.func_77973_b()).selectPreviousSpell(wand);
                        player.func_184597_cx();
                        break;
                    }
                    case RESURRECT_BUTTON: {
                        ItemStack stack;
                        if (player.field_70128_L && Resurrection.getRemainingWaitTime(player.field_70725_aQ) == 0 && (stack = (ItemStack)InventoryUtils.getHotbar((EntityPlayer)player).stream().filter(s -> Resurrection.canStackResurrect(s, (EntityPlayer)player)).findFirst().orElse(null)) != null) {
                            ((ISpellCastingItem)stack.func_77973_b()).cast(stack, Spells.resurrection, (EntityPlayer)player, EnumHand.MAIN_HAND, 0, new SpellModifiers());
                            break;
                        }
                        Wizardry.logger.warn("Received a resurrect button packet, but the player that sent it was not currently able to resurrect. This should not happen!");
                        break;
                    }
                    case CANCEL_RESURRECT: {
                        if (player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) break;
                        if (player.field_70128_L) {
                            ItemStack stack = InventoryUtils.getHotbar((EntityPlayer)player).stream().filter(s -> Resurrection.canStackResurrect(s, (EntityPlayer)player)).findFirst().orElse(null);
                            if (stack != null) {
                                player.func_146097_a(stack, true, false);
                                player.field_71071_by.func_184437_d(stack);
                                break;
                            }
                            Wizardry.logger.warn("Received a cancel resurrect packet, but the player that sent it was not holding a wand with the resurrection spell. This should not happen!");
                        }
                        Wizardry.logger.warn("Received a cancel resurrect packet, but the player that sent it was not currently dead. This should not happen!");
                        break;
                    }
                    case POSSESSION_PROJECTILE: {
                        if (!Possession.isPossessing((EntityPlayer)player)) {
                            Wizardry.logger.warn("Received a possession projectile packet, but the player that sent it is not currently possessing anything!");
                        }
                        Possession.shootProjectile((EntityPlayer)player);
                    }
                }
            });
        }
        return null;
    }

    public static class Message
    implements IMessage {
        private ControlType controlType;

        public Message() {
        }

        public Message(ControlType type) {
            this.controlType = type;
        }

        public void fromBytes(ByteBuf buf) {
            this.controlType = ControlType.values()[buf.readInt()];
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.controlType.ordinal());
        }
    }

    public static enum ControlType {
        APPLY_BUTTON,
        NEXT_SPELL_KEY,
        PREVIOUS_SPELL_KEY,
        RESURRECT_BUTTON,
        CANCEL_RESURRECT,
        POSSESSION_PROJECTILE;

    }
}

