/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.potion;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.potion.ICustomPotionParticles;
import electroblob.wizardry.potion.PotionMagicEffect;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class PotionFrostStep
extends PotionMagicEffect
implements ICustomPotionParticles {
    private static final Field prevBlockPos = ObfuscationReflectionHelper.findField(EntityLivingBase.class, (String)"field_184620_bC");

    public PotionFrostStep(boolean isBadEffect, int liquidColour) {
        super(isBadEffect, liquidColour, new ResourceLocation("ebwizardry", "textures/gui/potion_icons/frost_step.png"));
        this.func_76390_b("potion.ebwizardry:frost_step");
    }

    @Override
    public void spawnCustomParticle(World world, double x, double y, double z) {
        ParticleBuilder.create(ParticleBuilder.Type.SNOW).pos(x, y, z).time(15 + world.field_73012_v.nextInt(5)).spawn(world);
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase host = event.getEntityLiving();
        if (host.func_70644_a(WizardryPotions.frost_step) && !host.field_70170_p.field_72995_K) {
            BlockPos currentPos = new BlockPos((Entity)host);
            try {
                if (!currentPos.equals(prevBlockPos.get(host))) {
                    prevBlockPos.set(host, currentPos);
                    int strength = host.func_70660_b(WizardryPotions.frost_step).func_76458_c();
                    EnchantmentFrostWalker.func_185266_a((EntityLivingBase)host, (World)host.field_70170_p, (BlockPos)currentPos, (int)strength);
                    if (host instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)host, WizardryItems.charm_lava_walking)) {
                        PotionFrostStep.freezeNearbyLava(host, host.field_70170_p, currentPos, strength);
                    }
                }
            }
            catch (IllegalAccessException e) {
                Wizardry.logger.error("Error accessing living entity previous block pos:", (Throwable)e);
            }
        }
    }

    private static void freezeNearbyLava(EntityLivingBase living, World world, BlockPos pos, int level) {
        if (living.field_70122_E) {
            float f = Math.min(16, 2 + level);
            BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos(0, 0, 0);
            for (BlockPos.MutableBlockPos pos2 : BlockPos.func_177975_b((BlockPos)pos.func_177963_a((double)(-f), -1.0, (double)(-f)), (BlockPos)pos.func_177963_a((double)f, -1.0, (double)f))) {
                IBlockState state2;
                if (!(pos2.func_177957_d(living.field_70165_t, living.field_70163_u, living.field_70161_v) <= (double)(f * f))) continue;
                pos1.func_181079_c(pos2.func_177958_n(), pos2.func_177956_o() + 1, pos2.func_177952_p());
                IBlockState state1 = world.func_180495_p((BlockPos)pos1);
                if (state1.func_185904_a() != Material.field_151579_a || !BlockUtils.isLavaSource(state2 = world.func_180495_p((BlockPos)pos2)) || !world.func_190527_a(WizardryBlocks.obsidian_crust, (BlockPos)pos2, false, EnumFacing.DOWN, null)) continue;
                world.func_175656_a((BlockPos)pos2, WizardryBlocks.obsidian_crust.func_176223_P());
                world.func_175684_a(pos2.func_185334_h(), WizardryBlocks.obsidian_crust, MathHelper.func_76136_a((Random)living.func_70681_au(), (int)60, (int)120));
            }
        }
    }
}

