/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class CurseOfSoulbinding
extends SpellRay {
    public static final IStoredVariable<Set<UUID>> TARGETS_KEY = new IStoredVariable.StoredVariable<Set, NBTTagList>("soulboundCreatures", s -> NBTExtras.listToNBT(s, NBTUtil::func_186862_a), t -> new HashSet<UUID>(NBTExtras.NBTToList(t, NBTUtil::func_186860_b)), Persistence.DIMENSION_CHANGE);

    public CurseOfSoulbinding() {
        super("curse_of_soulbinding", SpellActions.POINT, false);
        this.soundValues(1.0f, 1.1f, 0.2f);
        WizardData.registerStoredVariables(TARGETS_KEY);
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        WizardData data;
        if (EntityUtils.isLiving(target) && caster instanceof EntityPlayer && (data = WizardData.get((EntityPlayer)caster)) != null) {
            if (CurseOfSoulbinding.getSoulboundCreatures(data).add(target.func_110124_au())) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(WizardryPotions.curse_of_soulbinding, Integer.MAX_VALUE));
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.4f, 0.0f, 0.0f).spawn(world);
        ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.1f, 0.0f, 0.0f).spawn(world);
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(1.0f, 0.8f, 1.0f).spawn(world);
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        EntityPlayer player;
        WizardData data;
        if (!(event.getEntity().field_70170_p.field_72995_K || !(event.getEntityLiving() instanceof EntityPlayer) || event.getSource().func_76363_c() || event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).isRetaliatory() || (data = WizardData.get(player = (EntityPlayer)event.getEntityLiving())) == null)) {
            Iterator<UUID> iterator = CurseOfSoulbinding.getSoulboundCreatures(data).iterator();
            while (iterator.hasNext()) {
                Entity entity = EntityUtils.getEntityByUUID(player.field_70170_p, iterator.next());
                if (entity == null) {
                    iterator.remove();
                }
                if (!(entity instanceof EntityLivingBase) || !DamageSafetyChecker.attackEntitySafely(entity, MagicDamage.causeDirectMagicDamage((Entity)player, MagicDamage.DamageType.MAGIC, true), event.getAmount(), event.getSource().func_76355_l(), DamageSource.field_76376_m, false)) continue;
                entity.func_184185_a(WizardrySounds.SPELL_CURSE_OF_SOULBINDING_RETALIATE, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.2f + 1.0f);
            }
        }
    }

    public static Set<UUID> getSoulboundCreatures(WizardData data) {
        if (data.getVariable(TARGETS_KEY) == null) {
            HashSet<UUID> result = new HashSet<UUID>();
            data.setVariable(TARGETS_KEY, result);
            return result;
        }
        return data.getVariable(TARGETS_KEY);
    }
}

