/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityDragonFireball;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class DragonFireball
extends Spell {
    public static final String ACCELERATION = "acceleration";

    public DragonFireball() {
        super("dragon_fireball", EnumAction.NONE, false);
        this.addProperties(ACCELERATION);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        if (!world.field_72995_K) {
            EntityDragonFireball fireball = new EntityDragonFireball(world, (EntityLivingBase)caster, 1.0, 1.0, 1.0);
            fireball.func_70107_b(caster.field_70165_t + look.field_72450_a, caster.field_70163_u + look.field_72448_b + 1.3, caster.field_70161_v + look.field_72449_c);
            double acceleration = this.getProperty(ACCELERATION).doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
            fireball.field_70232_b = look.field_72450_a * acceleration;
            fireball.field_70233_c = look.field_72448_b * acceleration;
            fireball.field_70230_d = look.field_72449_c * acceleration;
            world.func_72838_d((Entity)fireball);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        caster.func_184609_a(hand);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                EntityDragonFireball fireball = new EntityDragonFireball(world, (EntityLivingBase)caster, 1.0, 1.0, 1.0);
                double dx = target.field_70165_t - caster.field_70165_t;
                double dy = target.field_70163_u + (double)(target.field_70131_O / 2.0f) - (caster.field_70163_u + (double)(caster.field_70131_O / 2.0f));
                double dz = target.field_70161_v - caster.field_70161_v;
                double acceleration = this.getProperty(ACCELERATION).doubleValue();
                fireball.field_70232_b = dx / (double)caster.func_70032_d((Entity)target) * acceleration;
                fireball.field_70233_c = dy / (double)caster.func_70032_d((Entity)target) * acceleration;
                fireball.field_70230_d = dz / (double)caster.func_70032_d((Entity)target) * acceleration;
                fireball.func_70107_b(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e(), caster.field_70161_v);
                world.func_72838_d((Entity)fireball);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }
}

