/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FontOfMana
extends SpellAreaEffect {
    public FontOfMana() {
        super("font_of_mana", SpellActions.POINT_UP, false);
        this.soundValues(0.7f, 1.2f, 0.4f);
        this.particleDensity(1.25f);
        this.targetAllies(true);
        this.alwaysSucceed(true);
        this.addProperties("effect_duration", "effect_strength");
    }

    @Override
    protected boolean affectEntity(World world, Vec3d origin, @Nullable EntityLivingBase caster, EntityLivingBase target, int targetCount, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityPlayer) {
            target.func_70690_d(new PotionEffect(WizardryPotions.font_of_mana, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), (int)((float)this.getProperty("effect_strength").intValue() + (modifiers.get("potency") - 1.0f) * 2.0f)));
        }
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z) {
        float hue = world.field_73012_v.nextFloat() * 0.4f;
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.03, 0.0).time(50).clr(1.0f, 1.0f - hue, 0.6f + hue).spawn(world);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() != null && event.getCaster().func_70644_a(WizardryPotions.font_of_mana)) {
            event.getModifiers().set(WizardryItems.cooldown_upgrade, event.getModifiers().get(WizardryItems.cooldown_upgrade) / (float)(2 + event.getCaster().func_70660_b(WizardryPotions.font_of_mana).func_76458_c()), false);
        }
    }
}

