/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class Mine
extends SpellRay {
    private static final Method getSilkTouchDrop = ObfuscationReflectionHelper.findMethod(Block.class, (String)"func_180643_i", ItemStack.class, (Class[])new Class[]{IBlockState.class});

    public Mine() {
        super("mine", SpellActions.POINT, false);
        this.ignoreLivingEntities(true);
        this.particleSpacing(0.5);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            if (caster.func_184614_ca().func_77973_b() instanceof ISpellCastingItem) {
                caster.func_184609_a(EnumHand.MAIN_HAND);
            } else if (caster.func_184592_cb().func_77973_b() instanceof ISpellCastingItem) {
                caster.func_184609_a(EnumHand.OFF_HAND);
            }
        }
        if (!world.field_72995_K) {
            if (BlockUtils.isBlockUnbreakable(world, pos)) {
                return false;
            }
            if (!EntityUtils.canDamageBlocks((Entity)caster, world)) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos);
            int harvestLevel = (int)((modifiers.get("potency") - 1.0f) / 0.15f + 0.5f);
            if (harvestLevel > 0) {
                --harvestLevel;
            }
            if (state.func_177230_c().getHarvestLevel(state) <= harvestLevel || harvestLevel >= 3) {
                boolean flag = false;
                int blastUpgradeCount = (int)((modifiers.get(WizardryItems.blast_upgrade) - 1.0f) / 0.25f + 0.5f);
                float radius = 0.5f + 0.73f * (float)blastUpgradeCount;
                List<BlockPos> sphere = BlockUtils.getBlockSphere(pos, radius);
                for (BlockPos pos1 : sphere) {
                    IBlockState state1;
                    if (BlockUtils.isBlockUnbreakable(world, pos1) || (state1 = world.func_180495_p(pos1)).func_177230_c().getHarvestLevel(state1) > harvestLevel && harvestLevel < 3) continue;
                    if (caster instanceof EntityPlayerMP) {
                        boolean silkTouch;
                        boolean bl = silkTouch = state1.func_177230_c().canSilkHarvest(world, pos1, state1, (EntityPlayer)caster) && ItemArtefact.isArtefactActive((EntityPlayer)caster, WizardryItems.charm_silk_touch);
                        int xp = BlockUtils.checkBlockBreakXP((Entity)caster, world, pos);
                        if (xp < 0) continue;
                        if (silkTouch) {
                            ItemStack stack;
                            flag = world.func_175655_b(pos1, false);
                            if (!flag || (stack = Mine.getSilkTouchDrop(state1)) == null) continue;
                            Block.func_180635_a((World)world, (BlockPos)pos1, (ItemStack)stack);
                            continue;
                        }
                        flag = world.func_175655_b(pos1, true);
                        if (!flag) continue;
                        state1.func_177230_c().func_180637_b(world, pos1, xp);
                        continue;
                    }
                    if (!BlockUtils.canBreakBlock((Entity)caster, world, pos)) continue;
                    flag = world.func_175655_b(pos1, true) || flag;
                }
                return flag;
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create(ParticleBuilder.Type.DUST).pos(x, y, z).time(20 + world.field_73012_v.nextInt(5)).clr(0.9f, 0.95f, 1.0f).shaded(false).spawn(world);
    }

    private static ItemStack getSilkTouchDrop(IBlockState state) {
        try {
            return (ItemStack)getSilkTouchDrop.invoke((Object)state.func_177230_c(), state);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Wizardry.logger.error("Error while reflectively retrieving silk touch drop", (Throwable)e);
            return null;
        }
    }
}

