/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.packet.PacketSpellProperties;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.SpellProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public abstract class Spell
extends IForgeRegistryEntry.Impl<Spell>
implements Comparable<Spell> {
    public static final String DAMAGE = "damage";
    public static final String RANGE = "range";
    public static final String DURATION = "duration";
    public static final String EFFECT_RADIUS = "effect_radius";
    public static final String BLAST_RADIUS = "blast_radius";
    public static final String EFFECT_DURATION = "effect_duration";
    public static final String EFFECT_STRENGTH = "effect_strength";
    public static final String BURN_DURATION = "burn_duration";
    public static final String DIRECT_DAMAGE = "direct_damage";
    public static final String SPLASH_DAMAGE = "splash_damage";
    public static final String HEALTH = "health";
    public static final String SEEKING_STRENGTH = "seeking_strength";
    public static final String DIRECT_EFFECT_DURATION = "direct_effect_duration";
    public static final String DIRECT_EFFECT_STRENGTH = "direct_effect_strength";
    public static final String SPLASH_EFFECT_DURATION = "splash_effect_duration";
    public static final String SPLASH_EFFECT_STRENGTH = "splash_effect_strength";
    public static final String TIER_MATCH_PREFIX = "tier";
    public static final String ELEMENT_MATCH_PREFIX = "element";
    public static final String TYPE_MATCH_PREFIX = "type";
    public static final String DISCOVERED_MATCH_PREFIX = "discovered";
    public static final String MODID_MATCH_PREFIX = "modid";
    public static final String TIER_MATCH_ALIAS = "t";
    public static final String ELEMENT_MATCH_ALIAS = "e";
    public static final String TYPE_MATCH_ALIAS = "p";
    public static final String DISCOVERED_MATCH_ALIAS = "d";
    public static final String MODID_MATCH_ALIAS = "m";
    public static final String MATCH_CONDITION_SEPARATOR = ";";
    public static final String MATCH_KEY_VALUE_SEPARATOR = "=";
    public static final String MATCH_VALUE_SEPARATOR = ",";
    public static IForgeRegistry<Spell> registry;
    private final String unlocalisedName;
    private SpellProperties properties;
    private SpellProperties globalProperties;
    private Set<String> propertyKeys = new HashSet<String>();
    public final EnumAction action;
    public final boolean isContinuous;
    private final ResourceLocation icon;
    private boolean enabled = true;
    @Nullable
    protected final SoundEvent[] sounds;
    protected float volume = 1.0f;
    protected float pitch = 1.0f;
    protected float pitchVariation = 0.0f;
    protected Item[] applicableItems;
    protected BiPredicate<EntityLiving, Boolean> npcSelector;
    private static int nextSpellId;
    private final int id;

    Spell(String name, EnumAction action, boolean isContinuous) {
        this("ebwizardry", name, action, isContinuous);
    }

    public Spell(String modID, String name, EnumAction action, boolean isContinuous) {
        this.setRegistryName(modID, name);
        this.unlocalisedName = this.getRegistryName().toString();
        this.action = action;
        this.isContinuous = isContinuous;
        this.icon = new ResourceLocation(modID, "textures/spells/" + name + ".png");
        this.sounds = this.createSounds();
        this.id = nextSpellId++;
        this.items(WizardryItems.spell_book, WizardryItems.scroll);
        this.npcSelector((e, o) -> false);
    }

    public void init() {
    }

    protected SoundEvent[] createSounds() {
        return new SoundEvent[]{WizardrySounds.createSound(this.getRegistryName().func_110624_b(), "spell." + this.getRegistryName().func_110623_a())};
    }

    public final Spell addProperties(String ... keys) {
        if (this.arePropertiesInitialised()) {
            throw new IllegalStateException("Tried to add spell properties after they were initialised");
        }
        for (String key : keys) {
            if (!this.propertyKeys.contains(key)) continue;
            Wizardry.logger.warn("Tried to add a duplicate property key '" + key + "' to spell " + this.getRegistryName());
        }
        Collections.addAll(this.propertyKeys, keys);
        return this;
    }

    public final String[] getPropertyKeys() {
        return this.propertyKeys.toArray(new String[0]);
    }

    public final boolean arePropertiesInitialised() {
        return this.properties != null;
    }

    public void setProperties(@Nonnull SpellProperties properties) {
        if (!this.arePropertiesInitialised()) {
            this.properties = properties;
            if (this.globalProperties == null) {
                this.globalProperties = properties;
            }
        } else {
            Wizardry.logger.info("A mod attempted to set a spell's properties, but they were already initialised.");
        }
    }

    public void setPropertiesClient(SpellProperties properties) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
            Wizardry.logger.warn("Spell#setPropertiesClient called from the server side!");
        }
        if (!this.arePropertiesInitialised()) {
            this.properties = properties;
        }
    }

    public static void syncProperties(EntityPlayerMP player) {
        ArrayList<Spell> spells = new ArrayList<Spell>(registry.getValuesCollection());
        spells.sort(Comparator.comparingInt(Spell::networkID));
        WizardryPacketHandler.net.sendTo((IMessage)new PacketSpellProperties.Message((SpellProperties[])spells.stream().map(s -> s.properties).toArray(SpellProperties[]::new)), player);
    }

    private static void clearProperties() {
        for (Spell spell : registry) {
            spell.properties = null;
        }
    }

    public final SoundEvent createSoundWithSuffix(String suffix) {
        return WizardrySounds.createSound(this.getRegistryName().func_110624_b(), "spell." + this.getRegistryName().func_110623_a() + "." + suffix);
    }

    public final SoundEvent[] createSoundsWithSuffixes(String ... suffixes) {
        return (SoundEvent[])Arrays.stream(suffixes).map(this::createSoundWithSuffix).toArray(SoundEvent[]::new);
    }

    public final SoundEvent[] createContinuousSpellSounds() {
        return this.createSoundsWithSuffixes("start", "loop", "end");
    }

    public abstract boolean cast(World var1, EntityPlayer var2, EnumHand var3, int var4, SpellModifiers var5);

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return false;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return false;
    }

    public void finishCasting(World world, @Nullable EntityLivingBase caster, double x, double y, double z, @Nullable EnumFacing direction, int duration, SpellModifiers modifiers) {
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return this.npcSelector.test(npc, override);
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean requiresPacket() {
        return true;
    }

    public final int metadata() {
        return ((ForgeRegistry)registry).getID((IForgeRegistryEntry)this);
    }

    public final int networkID() {
        return this.id;
    }

    public final ResourceLocation getIcon() {
        return this.icon;
    }

    public final SoundEvent[] getSounds() {
        return this.sounds;
    }

    public final Tier getTier() {
        return this.arePropertiesInitialised() ? this.properties.tier : Tier.NOVICE;
    }

    public final Element getElement() {
        return this.arePropertiesInitialised() ? this.properties.element : Element.MAGIC;
    }

    public final SpellType getType() {
        return this.arePropertiesInitialised() ? this.properties.type : SpellType.UTILITY;
    }

    public final int getCost() {
        return this.arePropertiesInitialised() ? this.properties.cost : 0;
    }

    public final int getChargeup() {
        return this.arePropertiesInitialised() ? this.properties.chargeup : 0;
    }

    public final int getCooldown() {
        return this.arePropertiesInitialised() ? this.properties.cooldown : 0;
    }

    public final boolean hasProperty(String identifier) {
        return this.arePropertiesInitialised() && this.properties.hasBaseValue(identifier);
    }

    public final Number getProperty(String identifier) {
        return this.arePropertiesInitialised() ? (Number)this.properties.getBaseValue(identifier) : (Number)0;
    }

    public final String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    protected String getTranslationKey() {
        return "spell." + this.unlocalisedName;
    }

    protected String getDescriptionTranslationKey() {
        return "spell." + this.unlocalisedName + ".desc";
    }

    public String getDisplayName() {
        return Wizardry.proxy.translate(this.getTranslationKey(), new Object[0]);
    }

    public ITextComponent getNameForTranslation() {
        return new TextComponentTranslation(this.getTranslationKey(), new Object[0]);
    }

    public String getDisplayNameWithFormatting() {
        return Wizardry.proxy.translate(this.getTranslationKey(), this.getElement().getColour(), new Object[0]);
    }

    public ITextComponent getNameForTranslationFormatted() {
        return new TextComponentTranslation(this.getTranslationKey(), new Object[0]).func_150255_a(this.getElement().getColour());
    }

    public String getDescription() {
        return Wizardry.proxy.translate(this.getDescriptionTranslationKey(), new Object[0]);
    }

    public boolean matches(@Nonnull String text) {
        String[] conditions;
        if (text.isEmpty()) {
            return true;
        }
        boolean discovered = Wizardry.proxy.shouldDisplayDiscovered(this, null);
        for (String condition : conditions = text.split(MATCH_CONDITION_SEPARATOR)) {
            String target;
            String[] args = condition.split(MATCH_KEY_VALUE_SEPARATOR, 2);
            if (args.length < 2) {
                return discovered && this.getDisplayName().toLowerCase(Locale.ROOT).contains(text);
            }
            String key = args[0];
            String[] values = args[1].split(MATCH_VALUE_SEPARATOR);
            switch (key) {
                case "tier": 
                case "t": {
                    target = this.getTier().getDisplayName().toLowerCase(Locale.ROOT);
                    break;
                }
                case "element": 
                case "e": {
                    if (!discovered) {
                        return false;
                    }
                    target = this.getElement().getDisplayName().toLowerCase(Locale.ROOT);
                    break;
                }
                case "type": 
                case "p": {
                    if (!discovered) {
                        return false;
                    }
                    target = this.getType().getDisplayName().toLowerCase(Locale.ROOT);
                    break;
                }
                case "modid": 
                case "m": {
                    if (!discovered) {
                        return false;
                    }
                    target = this.getRegistryName().func_110624_b().toLowerCase(Locale.ROOT);
                    break;
                }
                case "discovered": 
                case "d": {
                    target = Boolean.toString(discovered);
                    break;
                }
                default: {
                    return discovered && this.getDisplayName().toLowerCase(Locale.ROOT).contains(text);
                }
            }
            if (!Arrays.stream(values).noneMatch(target::contains)) continue;
            return false;
        }
        return true;
    }

    public Spell soundValues(float volume, float pitch, float pitchVariation) {
        this.volume = volume;
        this.pitch = pitch;
        this.pitchVariation = pitchVariation;
        return this;
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        if (!entity.func_174814_R()) {
            this.playSound(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ticksInUse, duration, modifiers, sounds);
        }
    }

    protected void playSound(World world, Vec3d pos, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSound(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, ticksInUse, duration, modifiers, sounds);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        List identifiers = Arrays.stream(sounds).map(s -> "spell." + this.getRegistryName().func_110623_a() + "." + s).collect(Collectors.toList());
        if (this.sounds != null) {
            for (SoundEvent sound : this.sounds) {
                ResourceLocation soundName = (ResourceLocation)SoundEvent.field_187505_a.func_177774_c((Object)sound);
                if (soundName == null || identifiers.size() != 0 && !identifiers.contains(soundName.func_110623_a())) continue;
                world.func_184148_a(null, x, y, z, sound, WizardrySounds.SPELLS, this.volume, this.pitch + this.pitchVariation * (world.field_73012_v.nextFloat() - 0.5f));
            }
        }
    }

    protected final void playSoundLoop(World world, EntityLivingBase entity, int ticksInUse) {
        if (ticksInUse == 0 && world.field_72995_K) {
            Wizardry.proxy.playSpellSoundLoop(entity, this, this.sounds, WizardrySounds.SPELLS, this.volume, this.pitch + this.pitchVariation * (world.field_73012_v.nextFloat() - 0.5f));
        }
    }

    protected final void playSoundLoop(World world, double x, double y, double z, int ticksInUse, int duration) {
        if (ticksInUse == 0 && world.field_72995_K) {
            Wizardry.proxy.playSpellSoundLoop(world, x, y, z, this, this.sounds, WizardrySounds.SPELLS, this.volume, this.pitch + this.pitchVariation * (world.field_73012_v.nextFloat() - 0.5f), duration);
        }
    }

    public final boolean isEnabled(SpellProperties.Context ... contexts) {
        return this.enabled && (contexts.length == 0 || this.properties.isEnabled(contexts));
    }

    public final void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    public boolean applicableForItem(Item item) {
        return Arrays.asList(this.applicableItems).contains(item);
    }

    public Spell items(Item ... applicableItems) {
        this.applicableItems = applicableItems;
        return this;
    }

    public Spell npcSelector(BiPredicate<EntityLiving, Boolean> selector) {
        this.npcSelector = selector;
        return this;
    }

    @Override
    public final int compareTo(Spell spell) {
        if (this.getTier().ordinal() > spell.getTier().ordinal()) {
            return 1;
        }
        if (this.getTier().ordinal() < spell.getTier().ordinal()) {
            return -1;
        }
        return Integer.compare(this.getElement().ordinal(), spell.getElement().ordinal());
    }

    public static int getTotalSpellCount() {
        return registry.getValuesCollection().size() - 1;
    }

    public static Spell byMetadata(int metadata) {
        Spell spell = (Spell)((ForgeRegistry)registry).getValue(metadata);
        return spell == null ? Spells.none : spell;
    }

    public static Spell byNetworkID(int id) {
        if (id < 0 || id >= registry.getValuesCollection().size()) {
            return Spells.none;
        }
        return registry.getValuesCollection().stream().filter(s -> s.id == id).findAny().orElse(Spells.none);
    }

    public static Spell get(String name) {
        ResourceLocation key = new ResourceLocation(name);
        if (key.func_110624_b().equals("minecraft")) {
            key = new ResourceLocation("ebwizardry", name);
        }
        return (Spell)registry.getValue(key);
    }

    public static Collection<ResourceLocation> getSpellNames() {
        HashSet<ResourceLocation> keys = new HashSet<ResourceLocation>(registry.getKeys());
        keys.remove(registry.getKey((IForgeRegistryEntry)Spells.none));
        return keys;
    }

    public static List<Spell> getSpells(Predicate<Spell> filter) {
        return registry.getValuesCollection().stream().filter(filter.and(s -> s != Spells.none)).collect(Collectors.toList());
    }

    public static List<Spell> getAllSpells() {
        return Spell.getSpells(s -> true);
    }

    @SubscribeEvent
    public static void onWorldLoadEvent(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            if (event.getWorld().field_73011_w.getDimension() != 0) {
                return;
            }
            Spell.clearProperties();
            SpellProperties.loadWorldSpecificSpellProperties(event.getWorld());
            for (Spell spell : registry) {
                if (spell.arePropertiesInitialised()) continue;
                spell.setProperties(spell.globalProperties);
            }
        }
    }

    @SubscribeEvent
    public static void onClientConnectEvent(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!event.isLocal()) {
            Spell.clearProperties();
        }
    }

    @SubscribeEvent
    public static void onClientDisconnectEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Spell.clearProperties();
        for (Spell spell : registry) {
            spell.setProperties(spell.globalProperties);
        }
    }

    static {
        nextSpellId = 0;
    }

    public static class TierElementFilter
    implements Predicate<Spell> {
        private Tier tier;
        private Element element;
        private SpellProperties.Context[] contexts;

        public TierElementFilter(Tier tier, Element element, SpellProperties.Context ... contexts) {
            this.tier = tier;
            this.element = element;
            this.contexts = contexts;
        }

        @Override
        public boolean test(Spell spell) {
            return !(!spell.isEnabled(this.contexts) || this.tier != null && spell.getTier() != this.tier || this.element != null && spell.getElement() != this.element);
        }
    }
}

