/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.EntitySpiritHorse;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SummonSpiritHorse
extends Spell {
    private static final String POTENCY_ATTRIBUTE_MODIFIER = "potency";
    public static final IStoredVariable<UUID> UUID_KEY = IStoredVariable.StoredVariable.ofUUID("spiritHorseUUID", Persistence.ALWAYS);

    public SummonSpiritHorse() {
        super("summon_spirit_horse", SpellActions.SUMMON, false);
        this.addProperties("summon_radius");
        this.soundValues(0.7f, 1.2f, 0.4f);
        WizardData.registerStoredVariables(UUID_KEY);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData data = WizardData.get(caster);
        if (!world.field_72995_K) {
            BlockPos pos;
            Entity oldHorse = EntityUtils.getEntityByUUID(world, data.getVariable(UUID_KEY));
            if (oldHorse != null) {
                oldHorse.func_70106_y();
            }
            if ((pos = BlockUtils.findNearbyFloorSpace((Entity)caster, 2, 4)) == null) {
                return false;
            }
            EntitySpiritHorse horse = new EntitySpiritHorse(world);
            horse.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            horse.func_110263_g(caster);
            horse.func_110251_o(true);
            world.func_72838_d((Entity)horse);
            horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.get(POTENCY_ATTRIBUTE_MODIFIER) - 1.0f), 2));
            horse.func_110148_a(EntitySpiritHorse.JUMP_STRENGTH).func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.amplified(POTENCY_ATTRIBUTE_MODIFIER, 0.25f) - 1.0f), 2));
            data.setVariable(UUID_KEY, horse.func_110124_au());
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }
}

