/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class Thunderstorm
extends Spell {
    public static final String LIGHTNING_BOLTS = "lightning_bolts";
    public static final String SECONDARY_DAMAGE = "secondary_damage";
    public static final String TERTIARY_DAMAGE = "tertiary_damage";
    public static final String SECONDARY_RANGE = "secondary_range";
    public static final String TERTIARY_RANGE = "tertiary_range";
    public static final String SECONDARY_MAX_TARGETS = "secondary_max_targets";
    public static final String TERTIARY_MAX_TARGETS = "tertiary_max_targets";
    private static final float CENTRE_RADIUS_FRACTION = 0.5f;

    public Thunderstorm() {
        super("thunderstorm", SpellActions.POINT_UP, false);
        this.soundValues(1.0f, 1.7f, 0.2f);
        this.addProperties("effect_radius", LIGHTNING_BOLTS, SECONDARY_DAMAGE, TERTIARY_DAMAGE, SECONDARY_RANGE, TERTIARY_RANGE, SECONDARY_MAX_TARGETS, TERTIARY_MAX_TARGETS);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.doCasting(world, (EntityLivingBase)caster, modifiers);
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return this.doCasting(world, (EntityLivingBase)caster, modifiers);
    }

    private boolean doCasting(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        if (world.func_175710_j(new BlockPos((Entity)caster))) {
            double maxRadius = this.getProperty("effect_radius").doubleValue();
            for (int i = 0; i < this.getProperty(LIGHTNING_BOLTS).intValue(); ++i) {
                double z;
                float angle;
                double radius = maxRadius * 0.5 + world.field_73012_v.nextDouble() * maxRadius * 0.5 * (double)modifiers.get(WizardryItems.blast_upgrade);
                double x = caster.field_70165_t + radius * (double)MathHelper.func_76134_b((float)(angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f));
                Integer y = BlockUtils.getNearestFloor(world, new BlockPos(x, caster.field_70163_u, z = caster.field_70161_v + radius * (double)MathHelper.func_76126_a((float)angle)), (int)maxRadius);
                if (y == null) continue;
                if (!world.field_72995_K) {
                    EntityLightningBolt lightning = new EntityLightningBolt(world, x, (double)y.intValue(), z, false);
                    lightning.getEntityData().func_186854_a("summoner", caster.func_110124_au());
                    lightning.getEntityData().func_74776_a("damageModifier", modifiers.get("potency"));
                    world.func_72942_c((Entity)lightning);
                }
                List<EntityLivingBase> secondaryTargets = EntityUtils.getLivingWithinRadius(this.getProperty(SECONDARY_RANGE).doubleValue(), x, y + 1, z, world);
                for (int j = 0; j < Math.min(secondaryTargets.size(), this.getProperty(SECONDARY_MAX_TARGETS).intValue()); ++j) {
                    EntityLivingBase secondaryTarget = secondaryTargets.get(j);
                    if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)secondaryTarget)) continue;
                    if (world.field_72995_K) {
                        ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).pos(x, y.intValue(), z).target((Entity)secondaryTarget).spawn(world);
                        ParticleBuilder.spawnShockParticles(world, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v);
                    }
                    this.playSound(world, secondaryTarget, 0, -1, modifiers, new String[0]);
                    secondaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), this.getProperty(SECONDARY_DAMAGE).floatValue() * modifiers.get("potency"));
                    List<EntityLivingBase> tertiaryTargets = EntityUtils.getLivingWithinRadius(this.getProperty(TERTIARY_RANGE).doubleValue(), secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v, world);
                    for (int k = 0; k < Math.min(tertiaryTargets.size(), this.getProperty(TERTIARY_MAX_TARGETS).intValue()); ++k) {
                        EntityLivingBase tertiaryTarget = tertiaryTargets.get(k);
                        if (secondaryTargets.contains(tertiaryTarget) || !AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)tertiaryTarget)) continue;
                        if (world.field_72995_K) {
                            ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).entity((Entity)secondaryTarget).pos(0.0, secondaryTarget.field_70131_O / 2.0f, 0.0).target((Entity)tertiaryTarget).spawn(world);
                            ParticleBuilder.spawnShockParticles(world, tertiaryTarget.field_70165_t, tertiaryTarget.field_70163_u + (double)(tertiaryTarget.field_70131_O / 2.0f), tertiaryTarget.field_70161_v);
                        }
                        this.playSound(world, tertiaryTarget, 0, -1, modifiers, new String[0]);
                        tertiaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), this.getProperty(TERTIARY_DAMAGE).floatValue() * modifiers.get("potency"));
                    }
                }
            }
            return true;
        }
        return false;
    }
}

