/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.block.BlockTransportationStone;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.packet.PacketTransportation;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Transportation
extends Spell {
    public static final String TELEPORT_COUNTDOWN = "teleport_countdown";
    public static final int MAX_REMEMBERED_LOCATIONS = 4;
    public static final IStoredVariable<List<Location>> LOCATIONS_KEY = new IStoredVariable.StoredVariable<List, NBTTagList>("stoneCirclePos", s -> NBTExtras.listToNBT(s, Location::toNBT), t -> new ArrayList<Location>(NBTExtras.NBTToList(t, Location::fromNBT)), Persistence.ALWAYS).setSynced();
    public static final IStoredVariable<Integer> COUNTDOWN_KEY = IStoredVariable.StoredVariable.ofInt("tpCountdown", Persistence.NEVER).withTicker(Transportation::update);

    public Transportation() {
        super("transportation", SpellActions.POINT_UP, false);
        this.addProperties(TELEPORT_COUNTDOWN);
        WizardData.registerStoredVariables(LOCATIONS_KEY, COUNTDOWN_KEY);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Integer countdown;
        WizardData data = WizardData.get(caster);
        if (world.field_72995_K) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        if (data != null && ((countdown = data.getVariable(COUNTDOWN_KEY)) == null || countdown == 0)) {
            List<Location> locations = data.getVariable(LOCATIONS_KEY);
            if (locations == null) {
                locations = new ArrayList<Location>(4);
                data.setVariable(LOCATIONS_KEY, locations);
            }
            if (locations.isEmpty()) {
                if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".undefined", new Object[0]), true);
                }
                return false;
            }
            if (ItemArtefact.isArtefactActive(caster, WizardryItems.charm_transportation)) {
                List<Location> locationsInDimension = locations.stream().filter(l -> l.dimension == caster.field_71093_bK).collect(Collectors.toList());
                if (locationsInDimension.isEmpty()) {
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".wrongdimension", new Object[0]), true);
                    }
                    return false;
                }
                Location destination = Transportation.getLocationAimedAt(caster, locationsInDimension, 1.0f);
                if (destination == null) {
                    return false;
                }
                if (this.attemptTravelTo(caster, world, destination.pos, modifiers)) {
                    locations.remove(destination);
                    locations.add(destination);
                    if (!world.field_72995_K) {
                        data.sync();
                    }
                    return true;
                }
            } else {
                Location destination = locations.get(locations.size() - 1);
                if (destination.dimension == caster.field_71093_bK) {
                    return this.attemptTravelTo(caster, world, destination.pos, modifiers);
                }
                if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".wrongdimension", new Object[0]), true);
                }
            }
        }
        return false;
    }

    public static Location getLocationAimedAt(EntityPlayer player, List<Location> locations, float partialTicks) {
        return locations.stream().filter(l -> Transportation.isLocationAimedAt(player, l.pos, partialTicks)).min(Comparator.comparingDouble(l -> Transportation.getLookDeviationAngle(player, l.pos, partialTicks))).orElse(null);
    }

    public static boolean isLocationAimedAt(EntityPlayer player, BlockPos pos, float partialTicks) {
        Vec3d origin = player.func_174824_e(partialTicks);
        Vec3d centre = GeometryUtils.getCentre(pos);
        Vec3d direction = centre.func_178788_d(origin);
        double distance = direction.func_72433_c();
        return Transportation.getLookDeviationAngle(player, pos, partialTicks) < Transportation.getIconSize(distance);
    }

    public static double getLookDeviationAngle(EntityPlayer player, BlockPos pos, float partialTicks) {
        Vec3d origin = player.func_174824_e(partialTicks);
        Vec3d look = player.func_70676_i(partialTicks);
        Vec3d centre = GeometryUtils.getCentre(pos);
        Vec3d direction = centre.func_178788_d(origin);
        double distance = direction.func_72433_c();
        return Math.acos(direction.func_72430_b(look) / distance);
    }

    public static double getIconSize(double distance) {
        return 0.05 + 2.0 / (distance + 5.0);
    }

    private boolean attemptTravelTo(EntityPlayer player, World world, BlockPos destination, SpellModifiers modifiers) {
        WizardData data = WizardData.get(player);
        if (BlockTransportationStone.testForCircle(world, destination)) {
            this.playSound(world, (EntityLivingBase)player, 0, -1, modifiers, new String[0]);
            player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 150, 0));
            data.setVariable(COUNTDOWN_KEY, this.getProperty(TELEPORT_COUNTDOWN).intValue());
            return true;
        }
        if (!world.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".missing", new Object[0]), true);
        }
        return false;
    }

    private static int update(EntityPlayer player, Integer countdown) {
        if (countdown == null) {
            return 0;
        }
        if (!player.field_70170_p.field_72995_K) {
            WizardData data = WizardData.get(player);
            List<Location> locations = data.getVariable(LOCATIONS_KEY);
            if (locations == null || locations.isEmpty()) {
                return 0;
            }
            Location destination = locations.get(locations.size() - 1);
            if (countdown == 1 && destination.dimension == player.field_71093_bK) {
                boolean teleportMount;
                Entity mount = player.func_184187_bx();
                if (mount != null) {
                    player.func_184210_p();
                }
                player.func_70634_a((double)destination.pos.func_177958_n() + 0.5, (double)destination.pos.func_177956_o(), (double)destination.pos.func_177952_p() + 0.5);
                boolean bl = teleportMount = mount != null && ItemArtefact.isArtefactActive(player, WizardryItems.charm_mount_teleporting);
                if (teleportMount) {
                    mount.func_70634_a((double)destination.pos.func_177958_n() + 0.5, (double)destination.pos.func_177956_o(), (double)destination.pos.func_177952_p() + 0.5);
                    player.func_184220_m(mount);
                }
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 50, 0));
                PacketTransportation.Message msg = new PacketTransportation.Message(destination.pos, (Entity)(teleportMount ? null : player));
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, player.field_70170_p.field_73011_w.getDimension());
            }
            if (countdown > 0) {
                Integer n = countdown;
                Integer n2 = countdown = Integer.valueOf(countdown - 1);
            }
        }
        return countdown;
    }
}

