/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class CustomSoundCategory {
    private static final String SRG_soundLevels = "field_186714_aM";
    private static final String SRG_SOUND_CATEGORIES = "field_187961_k";

    private CustomSoundCategory() {
    }

    public static SoundCategory add(String name) {
        String constantName = name.toUpperCase().replace(" ", "");
        String referenceName = constantName.toLowerCase();
        SoundCategory soundCategory = (SoundCategory)EnumHelper.addEnum(SoundCategory.class, (String)constantName, (Class[])new Class[]{String.class}, (Object[])new Object[]{referenceName});
        Map SOUND_CATEGORIES = (Map)ObfuscationReflectionHelper.getPrivateValue(SoundCategory.class, (Object)SoundCategory.VOICE, (String)SRG_SOUND_CATEGORIES);
        if (SOUND_CATEGORIES.containsKey(referenceName)) {
            throw new IllegalArgumentException("Clash in Sound Category name pools! Cannot insert " + constantName);
        }
        SOUND_CATEGORIES.put(referenceName, soundCategory);
        if (FMLLaunchHandler.side() == Side.CLIENT) {
            CustomSoundCategory.setSoundLevels();
        }
        return soundCategory;
    }

    @SideOnly(value=Side.CLIENT)
    private static void setSoundLevels() {
        EnumMap soundLevels = Maps.newEnumMap(SoundCategory.class);
        ObfuscationReflectionHelper.setPrivateValue(GameSettings.class, (Object)Minecraft.func_71410_x().field_71474_y, (Object)soundLevels, (String)SRG_soundLevels);
    }
}

