/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.util.WandHelper;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public final class SpellModifiers {
    public static final String POTENCY = "potency";
    public static final String COST = "cost";
    public static final String CHARGEUP = "chargeup";
    public static final String PROGRESSION = "progression";
    private final Map<String, Float> multiplierMap;
    private final Map<String, Float> syncedMultiplierMap;

    public SpellModifiers() {
        this.multiplierMap = new HashMap<String, Float>();
        this.syncedMultiplierMap = new HashMap<String, Float>();
    }

    private SpellModifiers(Map<String, Float> multiplierMap, Map<String, Float> syncedMultiplierMap) {
        this.multiplierMap = multiplierMap;
        this.syncedMultiplierMap = syncedMultiplierMap;
    }

    public SpellModifiers copy() {
        return new SpellModifiers(new HashMap<String, Float>(this.multiplierMap), new HashMap<String, Float>(this.syncedMultiplierMap));
    }

    public SpellModifiers set(Item upgrade, float multiplier, boolean needsSyncing) {
        this.set(WandHelper.getIdentifier(upgrade), multiplier, needsSyncing);
        return this;
    }

    public SpellModifiers set(String key, float multiplier, boolean needsSyncing) {
        this.multiplierMap.put(key, Float.valueOf(multiplier));
        if (needsSyncing) {
            this.syncedMultiplierMap.put(key, Float.valueOf(multiplier));
        }
        return this;
    }

    public float get(Item upgrade) {
        return this.get(WandHelper.getIdentifier(upgrade));
    }

    public float get(String key) {
        Float value = this.multiplierMap.get(key);
        return value == null ? 1.0f : value.floatValue();
    }

    public float amplified(String key, float scalar) {
        return (this.get(key) - 1.0f) * scalar + 1.0f;
    }

    public Map<String, Float> getModifiers() {
        return Collections.unmodifiableMap(this.multiplierMap);
    }

    public void reset() {
        this.multiplierMap.clear();
        this.syncedMultiplierMap.clear();
    }

    public void read(ByteBuf buf) {
        int entryCount = buf.readInt();
        for (int i = 0; i < entryCount; ++i) {
            this.set(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readFloat(), false);
        }
    }

    public void write(ByteBuf buf) {
        buf.writeInt(this.syncedMultiplierMap.size());
        for (Map.Entry<String, Float> entry : this.syncedMultiplierMap.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            buf.writeFloat(entry.getValue().floatValue());
        }
    }

    public static SpellModifiers fromNBT(NBTTagCompound nbt) {
        SpellModifiers modifiers = new SpellModifiers();
        for (String key : nbt.func_150296_c()) {
            modifiers.set(key, nbt.func_74760_g(key), true);
        }
        return modifiers;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry<String, Float> entry : this.multiplierMap.entrySet()) {
            nbt.func_74776_a(entry.getKey(), entry.getValue().floatValue());
        }
        return nbt;
    }
}

