/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.pureore.PureOreHelper;
import sirttas.elementalcraft.loot.function.RandomSpell;
import sirttas.elementalcraft.network.message.MessageHandler;
import sirttas.elementalcraft.network.proxy.ClientProxy;
import sirttas.elementalcraft.network.proxy.IProxy;
import sirttas.elementalcraft.spell.SpellTickManager;
import sirttas.elementalcraft.world.dimension.boss.BossDimension;
import sirttas.elementalcraft.world.feature.ECFeatures;

@Mod(value="elementalcraft")
public class ElementalCraft {
    public static final String MODID = "elementalcraft";
    public static final Logger LOGGER = LogManager.getLogger((String)"elementalcraft");
    private IProxy proxy = (IProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> () -> new IProxy(){});

    public ElementalCraft() {
        this.proxy.registerHandlers();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::setupServer);
        MinecraftForge.EVENT_BUS.addListener(SpellTickManager::serverTick);
    }

    private void setup(FMLCommonSetupEvent event) {
        MessageHandler.setup();
        ECFeatures.addToWorldgen();
        BossDimension.getDimensionType();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ECConfig.SPEC);
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new RandomSpell.Serializer());
    }

    private void setupServer(FMLServerStartedEvent event) {
        PureOreHelper.generatePureOres(event.getServer().func_199529_aN());
    }

    public static ResourceLocation createRL(String name) {
        return new ResourceLocation(MODID, name);
    }
}

