/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.BlockCrystalOre;
import sirttas.elementalcraft.block.BlockEC;
import sirttas.elementalcraft.block.ECPaneBlock;
import sirttas.elementalcraft.block.extractor.BlockExtractor;
import sirttas.elementalcraft.block.extractor.TileExtractor;
import sirttas.elementalcraft.block.extractor.improved.BlockImprovedExtractor;
import sirttas.elementalcraft.block.instrument.binder.BlockBinder;
import sirttas.elementalcraft.block.instrument.binder.TileBinder;
import sirttas.elementalcraft.block.instrument.firefurnace.BlockFireFurnace;
import sirttas.elementalcraft.block.instrument.firefurnace.TileFireFurnace;
import sirttas.elementalcraft.block.instrument.firefurnace.blast.BlockFireBlastFurnace;
import sirttas.elementalcraft.block.instrument.firefurnace.blast.TileFireBlastFurnace;
import sirttas.elementalcraft.block.instrument.infuser.BlockInfuser;
import sirttas.elementalcraft.block.instrument.infuser.TileInfuser;
import sirttas.elementalcraft.block.instrument.purifier.BlockPurifier;
import sirttas.elementalcraft.block.instrument.purifier.TilePurifier;
import sirttas.elementalcraft.block.pipe.BlockElementPipe;
import sirttas.elementalcraft.block.pipe.TileElementPipe;
import sirttas.elementalcraft.block.pureinfuser.BlockPedestal;
import sirttas.elementalcraft.block.pureinfuser.BlockPureInfuser;
import sirttas.elementalcraft.block.pureinfuser.TilePedestal;
import sirttas.elementalcraft.block.pureinfuser.TilePureInfuser;
import sirttas.elementalcraft.block.retriever.BlockRetriever;
import sirttas.elementalcraft.block.shrine.enderlock.BlockEnderLockShrine;
import sirttas.elementalcraft.block.shrine.enderlock.TileEnderLockShrine;
import sirttas.elementalcraft.block.shrine.firepylon.BlockFirePylon;
import sirttas.elementalcraft.block.shrine.firepylon.TileFirePylon;
import sirttas.elementalcraft.block.shrine.growth.BlockGrowthShrine;
import sirttas.elementalcraft.block.shrine.growth.TileGrowthShrine;
import sirttas.elementalcraft.block.shrine.harvest.BlockHarvestShrine;
import sirttas.elementalcraft.block.shrine.harvest.TileHarvestShrine;
import sirttas.elementalcraft.block.shrine.lava.BlockLavaShrine;
import sirttas.elementalcraft.block.shrine.lava.TileLavaShrine;
import sirttas.elementalcraft.block.shrine.ore.BlockOreShrine;
import sirttas.elementalcraft.block.shrine.ore.TileOreShrine;
import sirttas.elementalcraft.block.shrine.overload.BlockOverloadShrine;
import sirttas.elementalcraft.block.shrine.overload.TileOverloadShrine;
import sirttas.elementalcraft.block.shrine.sweet.BlockSweetShrine;
import sirttas.elementalcraft.block.shrine.sweet.TileSweetShrine;
import sirttas.elementalcraft.block.shrine.vacuum.BlockVacuumShrine;
import sirttas.elementalcraft.block.shrine.vacuum.TileVacuumShrine;
import sirttas.elementalcraft.block.source.BlockSource;
import sirttas.elementalcraft.block.spelldesk.BlockSpellDesk;
import sirttas.elementalcraft.block.tank.BlockTank;
import sirttas.elementalcraft.block.tank.BlockTankSmall;
import sirttas.elementalcraft.block.tank.TileTank;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.property.ECProperties;
import sirttas.elementalcraft.registry.RegistryHelper;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECBlocks {
    @ObjectHolder(value="elementalcraft:tank_small")
    public static BlockTankSmall tankSmall;
    @ObjectHolder(value="elementalcraft:tank")
    public static BlockTank tank;
    @ObjectHolder(value="elementalcraft:extractor")
    public static BlockExtractor extractor;
    @ObjectHolder(value="elementalcraft:extractor_improved")
    public static BlockImprovedExtractor improvedExtractor;
    @ObjectHolder(value="elementalcraft:infuser")
    public static BlockInfuser infuser;
    @ObjectHolder(value="elementalcraft:binder")
    public static BlockBinder binder;
    @ObjectHolder(value="elementalcraft:pedestal_fire")
    public static BlockPedestal firePedestal;
    @ObjectHolder(value="elementalcraft:pedestal_water")
    public static BlockPedestal waterPedestal;
    @ObjectHolder(value="elementalcraft:pedestal_earth")
    public static BlockPedestal earthPedestal;
    @ObjectHolder(value="elementalcraft:pedestal_air")
    public static BlockPedestal airPedestal;
    @ObjectHolder(value="elementalcraft:pureinfuser")
    public static BlockPureInfuser pureInfuser;
    @ObjectHolder(value="elementalcraft:firefurnace")
    public static BlockFireFurnace fireFurnace;
    @ObjectHolder(value="elementalcraft:fireblastfurnace")
    public static BlockFireBlastFurnace fireBlastFurnace;
    @ObjectHolder(value="elementalcraft:purifier")
    public static BlockPurifier purifier;
    @ObjectHolder(value="elementalcraft:elementpipe_impaired")
    public static BlockElementPipe impairedElementPipe;
    @ObjectHolder(value="elementalcraft:elementpipe")
    public static BlockElementPipe elementPipe;
    @ObjectHolder(value="elementalcraft:elementpipe_improved")
    public static BlockElementPipe improvedElementPipe;
    @ObjectHolder(value="elementalcraft:instrument_retriever")
    public static BlockRetriever instrumentRetriever;
    @ObjectHolder(value="elementalcraft:spell_desk")
    public static BlockSpellDesk spellDesk;
    @ObjectHolder(value="elementalcraft:firepylon")
    public static BlockFirePylon firePylon;
    @ObjectHolder(value="elementalcraft:vacuumshrine")
    public static BlockVacuumShrine vacuumShrine;
    @ObjectHolder(value="elementalcraft:growthshrine")
    public static BlockGrowthShrine growthShrine;
    @ObjectHolder(value="elementalcraft:harvestshrine")
    public static BlockHarvestShrine harvestShrine;
    @ObjectHolder(value="elementalcraft:lavashrine")
    public static BlockLavaShrine lavaShrine;
    @ObjectHolder(value="elementalcraft:oreshrine")
    public static BlockOreShrine oreShrine;
    @ObjectHolder(value="elementalcraft:overloadshrine")
    public static BlockOverloadShrine overloadShrine;
    @ObjectHolder(value="elementalcraft:sweetshrine")
    public static BlockSweetShrine sweetShrine;
    @ObjectHolder(value="elementalcraft:enderlockshrine")
    public static BlockEnderLockShrine enderLockShrine;
    @ObjectHolder(value="elementalcraft:source")
    public static BlockSource source;
    @ObjectHolder(value="elementalcraft:crystalore")
    public static BlockCrystalOre crystalOre;
    @ObjectHolder(value="elementalcraft:whiterock")
    public static BlockEC whiteRock;
    @ObjectHolder(value="elementalcraft:whiterock_slab")
    public static SlabBlock whiteRockSlab;
    @ObjectHolder(value="elementalcraft:whiterock_stairs")
    public static StairsBlock whiteRockStairs;
    @ObjectHolder(value="elementalcraft:whiterock_wall")
    public static WallBlock whiteRockWall;
    @ObjectHolder(value="elementalcraft:purerock")
    public static BlockEC pureRock;
    @ObjectHolder(value="elementalcraft:purerock_slab")
    public static SlabBlock pureRockSlab;
    @ObjectHolder(value="elementalcraft:purerock_stairs")
    public static StairsBlock pureRockStairs;
    @ObjectHolder(value="elementalcraft:purerock_wall")
    public static WallBlock pureRockWall;
    @ObjectHolder(value="elementalcraft:burnt_glass")
    public static BlockEC burntGlass;
    @ObjectHolder(value="elementalcraft:burnt_glass_pane")
    public static ECPaneBlock burntGlassPane;

    private ECBlocks() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        RegistryHelper.register(registry, new BlockTankSmall(), "tank_small");
        RegistryHelper.register(registry, new BlockTank(), "tank");
        RegistryHelper.register(registry, new BlockExtractor(), "extractor");
        RegistryHelper.register(registry, new BlockImprovedExtractor(), "extractor_improved");
        RegistryHelper.register(registry, new BlockInfuser(), "infuser");
        RegistryHelper.register(registry, new BlockBinder(), "binder");
        RegistryHelper.register(registry, new BlockPedestal(ElementType.FIRE), "pedestal_fire");
        RegistryHelper.register(registry, new BlockPedestal(ElementType.WATER), "pedestal_water");
        RegistryHelper.register(registry, new BlockPedestal(ElementType.EARTH), "pedestal_earth");
        RegistryHelper.register(registry, new BlockPedestal(ElementType.AIR), "pedestal_air");
        RegistryHelper.register(registry, new BlockPureInfuser(), "pureinfuser");
        RegistryHelper.register(registry, new BlockFireFurnace(), "firefurnace");
        RegistryHelper.register(registry, new BlockFireBlastFurnace(), "fireblastfurnace");
        RegistryHelper.register(registry, new BlockPurifier(), "purifier");
        RegistryHelper.register(registry, new BlockElementPipe((Integer)ECConfig.CONFIG.impairedPipeTransferAmount.get()), "elementpipe_impaired");
        RegistryHelper.register(registry, new BlockElementPipe((Integer)ECConfig.CONFIG.pipeTransferAmount.get()), "elementpipe");
        RegistryHelper.register(registry, new BlockElementPipe((Integer)ECConfig.CONFIG.improvedPipeTransferAmount.get()), "elementpipe_improved");
        RegistryHelper.register(registry, new BlockRetriever(), "instrument_retriever");
        RegistryHelper.register(registry, new BlockSpellDesk(), "spell_desk");
        RegistryHelper.register(registry, new BlockFirePylon(), "firepylon");
        RegistryHelper.register(registry, new BlockVacuumShrine(), "vacuumshrine");
        RegistryHelper.register(registry, new BlockGrowthShrine(), "growthshrine");
        RegistryHelper.register(registry, new BlockHarvestShrine(), "harvestshrine");
        RegistryHelper.register(registry, new BlockLavaShrine(), "lavashrine");
        RegistryHelper.register(registry, new BlockOreShrine(), "oreshrine");
        RegistryHelper.register(registry, new BlockOverloadShrine(), "overloadshrine");
        RegistryHelper.register(registry, new BlockSweetShrine(), "sweetshrine");
        RegistryHelper.register(registry, new BlockEnderLockShrine(), "enderlockshrine");
        RegistryHelper.register(registry, new BlockSource(), "source");
        RegistryHelper.register(registry, new BlockCrystalOre(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 3.0f)), "crystalore");
        RegistryHelper.register(registry, new BlockEC(ECProperties.Blocks.WHITEROCK), "whiterock");
        RegistryHelper.register(registry, new SlabBlock(ECProperties.Blocks.WHITEROCK), "whiterock_slab");
        RegistryHelper.register(registry, new StairsBlock(() -> whiteRock.func_176223_P(), ECProperties.Blocks.WHITEROCK), "whiterock_stairs");
        RegistryHelper.register(registry, new WallBlock(ECProperties.Blocks.WHITEROCK), "whiterock_wall");
        RegistryHelper.register(registry, new BlockEC(ECProperties.Blocks.PUREROCK), "purerock");
        RegistryHelper.register(registry, new SlabBlock(ECProperties.Blocks.PUREROCK), "purerock_slab");
        RegistryHelper.register(registry, new StairsBlock(() -> pureRock.func_176223_P(), ECProperties.Blocks.PUREROCK), "purerock_stairs");
        RegistryHelper.register(registry, new WallBlock(ECProperties.Blocks.PUREROCK), "purerock_wall");
        RegistryHelper.register(registry, new BlockEC(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.7f).func_200947_a(SoundType.field_185853_f).func_226896_b_()), "burnt_glass");
        RegistryHelper.register(registry, new ECPaneBlock(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.7f).func_200947_a(SoundType.field_185853_f).func_226896_b_()), "burnt_glass_pane");
    }

    @SubscribeEvent
    public static void initTileEntities(RegistryEvent.Register<TileEntityType<?>> evt) {
        IForgeRegistry r = evt.getRegistry();
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileTank::new, (Block[])new Block[]{tank, tankSmall}).func_206865_a(null), "tank");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileExtractor::new, (Block[])new Block[]{extractor, improvedExtractor}).func_206865_a(null), "extractor");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileInfuser::new, (Block[])new Block[]{infuser}).func_206865_a(null), "infuser");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileBinder::new, (Block[])new Block[]{binder}).func_206865_a(null), "binder");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TilePedestal::new, (Block[])new Block[]{firePedestal, waterPedestal, earthPedestal, airPedestal}).func_206865_a(null), "pedestal");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TilePureInfuser::new, (Block[])new Block[]{pureInfuser}).func_206865_a(null), "pureinfuser");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileFireFurnace::new, (Block[])new Block[]{fireFurnace}).func_206865_a(null), "firefurnace");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileFireBlastFurnace::new, (Block[])new Block[]{fireBlastFurnace}).func_206865_a(null), "fireblastfurnace");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TilePurifier::new, (Block[])new Block[]{purifier}).func_206865_a(null), "purifier");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileElementPipe::new, (Block[])new Block[]{impairedElementPipe, elementPipe, improvedElementPipe}).func_206865_a(null), "elementpipe");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileFirePylon::new, (Block[])new Block[]{firePylon}).func_206865_a(null), "firepylon");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileVacuumShrine::new, (Block[])new Block[]{vacuumShrine}).func_206865_a(null), "vacuumshrine");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileGrowthShrine::new, (Block[])new Block[]{growthShrine}).func_206865_a(null), "growthshrine");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileHarvestShrine::new, (Block[])new Block[]{harvestShrine}).func_206865_a(null), "harvestshrine");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileLavaShrine::new, (Block[])new Block[]{lavaShrine}).func_206865_a(null), "lavashrine");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileOreShrine::new, (Block[])new Block[]{oreShrine}).func_206865_a(null), "oreshrine");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileOverloadShrine::new, (Block[])new Block[]{overloadShrine}).func_206865_a(null), "overloadshrine");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileSweetShrine::new, (Block[])new Block[]{sweetShrine}).func_206865_a(null), "sweetshrine");
        RegistryHelper.register(r, TileEntityType.Builder.func_223042_a(TileEnderLockShrine::new, (Block[])new Block[]{enderLockShrine}).func_206865_a(null), "enderlockshrine");
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!"elementalcraft".equals(block.getRegistryName().func_110624_b())) continue;
            RegistryHelper.register(registry, new BlockItem(block, ECProperties.Items.DEFAULT_ITEM_PROPERTIES), block.getRegistryName());
        }
    }
}

