/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.extractor;

import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.tank.TileTank;
import sirttas.elementalcraft.block.tile.TileECTickable;
import sirttas.elementalcraft.config.ECConfig;

public class TileExtractor
extends TileECTickable {
    @ObjectHolder(value="elementalcraft:extractor")
    public static TileEntityType<TileExtractor> TYPE;
    int extractionAmount;

    public TileExtractor() {
        this((Integer)ECConfig.CONFIG.extractorExtractionAmount.get());
    }

    public TileExtractor(int extractionAmount) {
        super(TYPE);
        this.extractionAmount = extractionAmount;
    }

    public boolean hasSource() {
        return this.getSourceElementType() != ElementType.NONE;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.extractionAmount = compound.func_74762_e("extraction_amount");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("extraction_amount", this.extractionAmount);
        return compound;
    }

    protected Optional<BlockState> getSourceState() {
        return this.func_145830_o() ? Optional.of(this.func_145831_w().func_180495_p(this.field_174879_c.func_177984_a())) : Optional.empty();
    }

    public ElementType getSourceElementType() {
        return this.getSourceState().filter(s -> s.func_177230_c() == ECBlocks.source).map(ElementType::getElementType).orElse(ElementType.NONE);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.canExtract()) {
            this.getTank().inserElement(this.extractionAmount, this.getSourceElementType(), false);
        }
    }

    public boolean canExtract() {
        TileTank tank = this.getTank();
        return this.func_145830_o() && this.hasSource() && tank != null && tank.getElementAmount() < tank.getMaxElement();
    }
}

