/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.google.common.collect.Lists;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.pipe.BlockElementPipe;
import sirttas.elementalcraft.block.tile.TileECTickable;
import sirttas.elementalcraft.block.tile.element.IElementReceiver;
import sirttas.elementalcraft.block.tile.element.IElementSender;
import sirttas.elementalcraft.config.ECConfig;

public class TileElementPipe
extends TileECTickable {
    @ObjectHolder(value="elementalcraft:elementpipe")
    public static TileEntityType<TileElementPipe> TYPE;
    private Map<Direction, ConnectionType> connections = new EnumMap<Direction, ConnectionType>(Direction.class);
    private boolean updateState = true;
    private int transferedAmount = 0;
    private int maxTransferAmount;

    public TileElementPipe() {
        this((Integer)ECConfig.CONFIG.pipeTransferAmount.get());
    }

    public TileElementPipe(int maxTransferAmount) {
        super(TYPE);
        this.maxTransferAmount = maxTransferAmount;
    }

    private TileEntity getAdjacentTile(Direction face) {
        return this.func_145830_o() ? this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face)) : null;
    }

    private boolean isConnectedTo(Direction face) {
        ConnectionType type = this.getConection(face);
        return type != ConnectionType.NONE && type != ConnectionType.DISCONNECT;
    }

    private boolean isExtracting(Direction face) {
        return this.getConection(face) == ConnectionType.EXTRACT;
    }

    private ConnectionType getConection(Direction face) {
        if (this.connections.containsKey(face)) {
            return this.connections.get(face);
        }
        return ConnectionType.NONE;
    }

    private void setConection(Direction face, ConnectionType type) {
        this.connections.put(face, type);
        this.forceSync();
        this.updateState = true;
    }

    private void refresh(Direction face) {
        TileEntity other = this.getAdjacentTile(face);
        if (this.getConection(face) == ConnectionType.NONE) {
            if (other instanceof TileElementPipe) {
                this.setConection(face, ConnectionType.CONNECT);
            } else if (other instanceof IElementReceiver) {
                this.setConection(face, ConnectionType.INSERT);
            } else if (other instanceof IElementSender) {
                this.setConection(face, ConnectionType.EXTRACT);
            }
        } else if (other == null) {
            this.setConection(face, ConnectionType.NONE);
        }
    }

    public void refresh() {
        for (Direction face : Direction.values()) {
            this.refresh(face);
        }
    }

    private void transferElement(IElementSender sender) {
        Path path;
        IElementReceiver receiver;
        int amount = this.maxTransferAmount - this.transferedAmount;
        ElementType type = sender.getElementType();
        if (type != ElementType.NONE && (receiver = (path = new Path()).searchReceiver(this, type, sender.extractElement(amount, type, true))) != null) {
            int resultingAmount = path.amount - receiver.inserElement(sender.extractElement(path.amount, type, false), type, false);
            path.pipes.forEach(p -> p.transferedAmount += resultingAmount);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.refresh();
        this.transferedAmount = 0;
        this.connections.forEach((k, v) -> {
            TileEntity entity;
            if (v == ConnectionType.EXTRACT && (entity = this.getAdjacentTile((Direction)k)) instanceof IElementSender) {
                this.transferElement((IElementSender)entity);
            }
        });
        if (this.updateState && this.func_145830_o()) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_145831_w().func_180495_p(this.field_174879_c).func_206870_a((IProperty)BlockElementPipe.NORTH, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.NORTH)))).func_206870_a((IProperty)BlockElementPipe.EAST, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.EAST)))).func_206870_a((IProperty)BlockElementPipe.SOUTH, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.SOUTH)))).func_206870_a((IProperty)BlockElementPipe.WEST, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.WEST)))).func_206870_a((IProperty)BlockElementPipe.UP, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.UP)))).func_206870_a((IProperty)BlockElementPipe.DOWN, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.DOWN)))).func_206870_a((IProperty)BlockElementPipe.NORTH_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.NORTH)))).func_206870_a((IProperty)BlockElementPipe.EAST_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.EAST)))).func_206870_a((IProperty)BlockElementPipe.SOUTH_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.SOUTH)))).func_206870_a((IProperty)BlockElementPipe.WEST_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.WEST)))).func_206870_a((IProperty)BlockElementPipe.UP_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.UP)))).func_206870_a((IProperty)BlockElementPipe.DOWN_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.DOWN))));
            this.updateState = false;
        }
    }

    public ActionResultType activatePipe(Direction face) {
        TileEntity tile = this.getAdjacentTile(face);
        ConnectionType connection = this.getConection(face);
        switch (connection) {
            case INSERT: {
                if (tile instanceof IElementSender) {
                    this.setConection(face, ConnectionType.EXTRACT);
                } else {
                    this.setConection(face, ConnectionType.DISCONNECT);
                }
                return ActionResultType.SUCCESS;
            }
            case EXTRACT: 
            case CONNECT: {
                this.setConection(face, ConnectionType.DISCONNECT);
                if (tile instanceof TileElementPipe) {
                    ((TileElementPipe)tile).setConection(face.func_176734_d(), ConnectionType.DISCONNECT);
                }
                return ActionResultType.SUCCESS;
            }
            case DISCONNECT: {
                if (tile instanceof IElementReceiver) {
                    this.setConection(face, ConnectionType.INSERT);
                } else if (tile instanceof IElementSender) {
                    this.setConection(face, ConnectionType.EXTRACT);
                } else if (tile instanceof TileElementPipe) {
                    this.setConection(face, ConnectionType.CONNECT);
                    ((TileElementPipe)tile).setConection(face.func_176734_d(), ConnectionType.CONNECT);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        for (Direction face : Direction.values()) {
            this.setConection(face, ConnectionType.fromInteger(compound.func_74762_e(face.func_176610_l())));
        }
        this.maxTransferAmount = compound.func_74762_e("max_transfer_amount");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.connections.forEach((k, v) -> compound.func_74768_a(k.func_176610_l(), v.getValue()));
        compound.func_74768_a("max_transfer_amount", this.maxTransferAmount);
        return compound;
    }

    private static class Path {
        List<TileElementPipe> visited = Lists.newArrayListWithCapacity((int)100);
        List<TileElementPipe> pipes = Lists.newArrayListWithCapacity((int)100);
        int amount;

        private Path() {
        }

        private IElementReceiver searchReceiver(TileElementPipe pipe, ElementType type, int lastCount) {
            int count = Math.min(lastCount, pipe.maxTransferAmount - pipe.transferedAmount);
            if (count > 0 && !this.visited.contains(pipe)) {
                this.visited.add(pipe);
                for (Map.Entry connection : pipe.connections.entrySet()) {
                    TileEntity entity = pipe.getAdjacentTile((Direction)connection.getKey());
                    if (entity instanceof TileElementPipe && connection.getValue() == ConnectionType.CONNECT) {
                        IElementReceiver ret = this.searchReceiver((TileElementPipe)entity, type, count);
                        if (ret == null) continue;
                        this.pipes.add(pipe);
                        return ret;
                    }
                    if (entity instanceof IElementReceiver && connection.getValue() == ConnectionType.INSERT) {
                        IElementReceiver receiver = (IElementReceiver)entity;
                        if (receiver.inserElement(count, type, true) >= count) continue;
                        this.amount = count;
                        this.pipes.add(pipe);
                        return receiver;
                    }
                    pipe.refresh((Direction)connection.getKey());
                }
            }
            return null;
        }
    }

    private static enum ConnectionType {
        NONE(0),
        CONNECT(1),
        INSERT(2),
        EXTRACT(3),
        DISCONNECT(4);

        private final int value;

        private ConnectionType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ConnectionType fromInteger(int x) {
            for (ConnectionType type : ConnectionType.values()) {
                if (type.getValue() != x) continue;
                return type;
            }
            return NONE;
        }
    }
}

