/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.BlockECContainer;
import sirttas.elementalcraft.block.pureinfuser.TilePedestal;
import sirttas.elementalcraft.block.tile.TileEntityHelper;
import sirttas.elementalcraft.particle.ParticleHelper;

public class BlockPedestal
extends BlockECContainer {
    private static final VoxelShape BASE_1 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape BASE_2 = Block.func_208617_a((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
    private static final VoxelShape BASE_3 = Block.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape BASE = VoxelShapes.func_216384_a((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3});
    private static final VoxelShape AIR = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3});
    private static final VoxelShape EARTH = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)4.0, (double)3.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)3.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0)});
    public static final String NAME = "pedestal";
    public static final String NAME_FIRE = "pedestal_fire";
    public static final String NAME_WATER = "pedestal_water";
    public static final String NAME_EARTH = "pedestal_earth";
    public static final String NAME_AIR = "pedestal_air";
    private ElementType elementType;

    public BlockPedestal(ElementType type) {
        this.elementType = type;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TilePedestal();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.onSingleSlotActivated(world, pos, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        TileEntityHelper.getTileEntityAs((IBlockReader)world, pos, TilePedestal.class).filter(TilePedestal::isPureInfuserRunning).ifPresent(p -> {
            Direction offset = p.getPureInfuserDirection();
            ParticleHelper.createElementFlowParticle(p.getElementType(), world, new Vec3d((Vec3i)pos.func_177967_a(offset, 2)).func_72441_c(0.0, 0.7, 0.0), offset, 2.0f, rand);
        });
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (this.elementType == ElementType.AIR) {
            return AIR;
        }
        if (this.elementType == ElementType.EARTH) {
            return EARTH;
        }
        return BASE;
    }

    public ElementType getElementType() {
        return this.elementType;
    }
}

