/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.pureinfuser.TilePedestal;
import sirttas.elementalcraft.block.tile.TileECContainer;
import sirttas.elementalcraft.inventory.InventoryTileWrapper;
import sirttas.elementalcraft.inventory.SingleItemInventory;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.recipe.PureInfusionRecipe;

public class TilePureInfuser
extends TileECContainer {
    @ObjectHolder(value="elementalcraft:pureinfuser")
    public static TileEntityType<TilePureInfuser> TYPE;
    private float progress = 0.0f;
    private PureInfusionRecipe recipe;
    private final SingleItemInventory inventory = new SingleItemInventory(this::forceSync);

    public TilePureInfuser() {
        super(TYPE);
    }

    public boolean isRunning() {
        return this.progress > 0.0f;
    }

    public boolean isReciptAvalable() {
        if (this.recipe != null && this.recipe.matches(this)) {
            return true;
        }
        if (this.recipe != null) {
            this.forceSync();
        }
        this.recipe = this.func_145831_w().func_199532_z().func_215371_a(PureInfusionRecipe.TYPE, InventoryTileWrapper.from(this), this.func_145831_w()).orElse(null);
        return this.recipe != null;
    }

    public void process() {
        this.recipe.process(this);
        this.recipe = null;
        this.forceSync();
        if (this.field_145850_b.field_72995_K) {
            ParticleHelper.createCraftingParticle(ElementType.NONE, this.field_145850_b, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.0, 0.7, 0.0), this.field_145850_b.field_73012_v);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.makeProgress();
    }

    protected void makeProgress() {
        if (this.recipe != null && this.progress >= (float)this.recipe.getDuration()) {
            this.process();
            this.progress = 0.0f;
        } else {
            this.progress = this.isReciptAvalable() && this.consume(Direction.NORTH) && this.consume(Direction.SOUTH) && this.consume(Direction.WEST) && this.consume(Direction.EAST) ? (this.progress += 1.0f) : 0.0f;
        }
    }

    public float getProgress() {
        return this.progress;
    }

    public ItemStack getStackInPedestal(ElementType type) {
        TilePedestal pedestal = this.getPedestal(type);
        return pedestal != null ? pedestal.getItem() : ItemStack.field_190927_a;
    }

    public TilePedestal getPedestal(ElementType type) {
        TilePedestal pedestal = this.getPedestal(Direction.NORTH);
        if (pedestal == null || pedestal.getElementType() != type) {
            pedestal = this.getPedestal(Direction.SOUTH);
        }
        if (pedestal == null || pedestal.getElementType() != type) {
            pedestal = this.getPedestal(Direction.WEST);
        }
        if (pedestal == null || pedestal.getElementType() != type) {
            pedestal = this.getPedestal(Direction.EAST);
        }
        return pedestal != null && pedestal.getElementType() == type ? pedestal : null;
    }

    public void emptyPedestals() {
        this.setPedestalInventory(Direction.NORTH, ItemStack.field_190927_a);
        this.setPedestalInventory(Direction.SOUTH, ItemStack.field_190927_a);
        this.setPedestalInventory(Direction.WEST, ItemStack.field_190927_a);
        this.setPedestalInventory(Direction.EAST, ItemStack.field_190927_a);
    }

    private void setPedestalInventory(Direction direction, ItemStack stack) {
        TilePedestal pedestal = this.getPedestal(direction);
        if (pedestal != null) {
            pedestal.getInventory().func_70299_a(0, stack);
            pedestal.forceSync();
        }
    }

    private TilePedestal getPedestal(Direction direction) {
        TileEntity te = this.func_145830_o() ? this.func_145831_w().func_175625_s(this.field_174879_c.func_177967_a(direction, 3)) : null;
        return te instanceof TilePedestal ? (TilePedestal)te : null;
    }

    private boolean consume(Direction direction) {
        TilePedestal pedestal = this.getPedestal(direction);
        int elementPerTick = this.recipe.getElementPerTick();
        return pedestal != null && pedestal.consumeElement(elementPerTick) == elementPerTick;
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.progress = compound.func_74760_g("progress");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("progress", this.progress);
        return compound;
    }

    @Override
    public void func_174888_l() {
        super.func_174888_l();
        this.recipe = null;
        this.progress = 0.0f;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.func_70301_a(0);
    }
}

