/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.tile.TileECTickable;
import sirttas.elementalcraft.block.tile.element.IElementReceiver;
import sirttas.elementalcraft.config.ECConfig;

public abstract class TileShrine
extends TileECTickable
implements IElementReceiver {
    private ElementType elementType = ElementType.NONE;
    private int elementAmount = 0;
    protected int elementMax;
    private boolean running;
    private double tick;
    private double periode;

    public TileShrine(TileEntityType<?> tileEntityTypeIn, ElementType type) {
        this(tileEntityTypeIn, type, 1.0);
    }

    public TileShrine(TileEntityType<?> tileEntityTypeIn, ElementType type, double periode) {
        super(tileEntityTypeIn);
        this.elementMax = (Integer)ECConfig.CONFIG.shrineMaxAmount.get();
        this.running = false;
        this.tick = 0.0;
        this.periode = 1.0;
        this.elementType = type;
        this.periode = periode;
    }

    protected int consumeElement(int i) {
        if (this.isPowered()) {
            return 0;
        }
        int newCount = Math.max(this.elementAmount - i, 0);
        int ret = this.elementAmount - newCount;
        this.elementAmount = newCount;
        if (ret > 0) {
            this.running = true;
        }
        this.forceSync();
        return ret;
    }

    @Override
    public int inserElement(int count, ElementType type, boolean simulate) {
        if (type != this.elementType && this.elementType != ElementType.NONE) {
            return 0;
        }
        int newCount = Math.min(this.elementAmount + count, this.elementMax);
        int ret = count - newCount + this.elementAmount;
        if (!simulate) {
            this.elementAmount = newCount;
            if (this.elementType == ElementType.NONE) {
                this.elementType = type;
            }
        }
        return ret;
    }

    protected abstract void doTick();

    @Override
    public final void func_73660_a() {
        super.func_73660_a();
        this.running = false;
        if (this.func_145830_o() && !this.isPowered()) {
            this.tick += 1.0;
            if (this.periode == 0.0) {
                ElementalCraft.LOGGER.warn("Shrine periode should not be 0");
                this.periode = 1.0;
            }
            while (this.tick >= this.periode) {
                this.doTick();
                this.tick -= this.periode;
            }
        }
    }

    public Direction getUpgradeDirection() {
        return Direction.DOWN;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public int getMaxElement() {
        return this.elementMax;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.elementType = ElementType.byName(compound.func_74779_i("element_type"));
        this.elementAmount = compound.func_74762_e("element_amount");
        this.running = compound.func_74767_n("running");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("element_type", this.elementType.func_176610_l());
        compound.func_74768_a("element_amount", this.elementAmount);
        compound.func_74757_a("running", this.running);
        return compound;
    }

    protected boolean randomChance(double chance) {
        return this.field_145850_b.field_73012_v.nextDouble() <= chance;
    }
}

