/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.tank;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import sirttas.elementalcraft.block.tank.AbstractBlockTank;
import sirttas.elementalcraft.block.tank.TileTank;
import sirttas.elementalcraft.tag.ECTags;

public class BlockTank
extends AbstractBlockTank {
    public static final String NAME = "tank";
    private static final VoxelShape BASE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape GLASS = Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private static final VoxelShape PIPE_1 = Block.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0);
    private static final VoxelShape PIPE_2 = Block.func_208617_a((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0);
    private static final VoxelShape PIPE_3 = Block.func_208617_a((double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0);
    private static final VoxelShape PIPE_4 = Block.func_208617_a((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape CONNECTOR = Block.func_208617_a((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape CONNECTOR_NORTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)1.0));
    private static final VoxelShape CONNECTOR_SOUTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)15.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape CONNECTOR_WEST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)1.0, (double)10.0, (double)10.0));
    private static final VoxelShape CONNECTOR_EAST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)14.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), (VoxelShape)Block.func_208617_a((double)15.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{GLASS, PIPE_1, PIPE_2, PIPE_3, PIPE_4, CONNECTOR});
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;

    public BlockTank() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileTank();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = SHAPE;
        if (Boolean.TRUE.equals(state.func_177229_b((IProperty)NORTH))) {
            VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CONNECTOR_NORTH);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((IProperty)SOUTH))) {
            VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CONNECTOR_SOUTH);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((IProperty)EAST))) {
            VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CONNECTOR_EAST);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((IProperty)WEST))) {
            VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CONNECTOR_WEST);
        }
        return shape;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new IProperty[]{NORTH, SOUTH, EAST, WEST});
    }

    private boolean isConnected(IWorld worldIn, BlockPos pos, Direction facing, BooleanProperty opposite) {
        BlockState state = worldIn.func_180495_p(pos.func_177972_a(facing));
        return ECTags.Blocks.PIPES.func_199685_a_((Object)state.func_177230_c()) && Boolean.TRUE.equals(state.func_177229_b((IProperty)opposite));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.isConnected((IWorld)context.func_195991_k(), context.func_195995_a(), Direction.NORTH, SOUTH)))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.isConnected((IWorld)context.func_195991_k(), context.func_195995_a(), Direction.SOUTH, NORTH)))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.isConnected((IWorld)context.func_195991_k(), context.func_195995_a(), Direction.EAST, EAST)))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.isConnected((IWorld)context.func_195991_k(), context.func_195995_a(), Direction.WEST, WEST)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        switch (facing) {
            case NORTH: {
                return (BlockState)stateIn.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(ECTags.Blocks.PIPES.func_199685_a_((Object)facingState.func_177230_c()) && Boolean.TRUE.equals(facingState.func_177229_b((IProperty)SOUTH))));
            }
            case SOUTH: {
                return (BlockState)stateIn.func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(ECTags.Blocks.PIPES.func_199685_a_((Object)facingState.func_177230_c()) && Boolean.TRUE.equals(facingState.func_177229_b((IProperty)NORTH))));
            }
            case EAST: {
                return (BlockState)stateIn.func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(ECTags.Blocks.PIPES.func_199685_a_((Object)facingState.func_177230_c()) && Boolean.TRUE.equals(facingState.func_177229_b((IProperty)WEST))));
            }
            case WEST: {
                return (BlockState)stateIn.func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(ECTags.Blocks.PIPES.func_199685_a_((Object)facingState.func_177230_c()) && Boolean.TRUE.equals(facingState.func_177229_b((IProperty)EAST))));
            }
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

