/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.pipe.BlockElementPipe;
import sirttas.elementalcraft.block.retriever.BlockRetriever;
import sirttas.elementalcraft.block.shrine.overload.BlockOverloadShrine;
import sirttas.elementalcraft.block.spelldesk.BlockSpellDesk;
import sirttas.elementalcraft.block.tank.BlockTank;

public class ECBlockStateProvider
extends BlockStateProvider {
    private ExistingFileHelper existingFileHelper;

    public ECBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "elementalcraft", exFileHelper);
        this.existingFileHelper = exFileHelper;
    }

    protected void registerStatesAndModels() {
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!"elementalcraft".equals(block.getRegistryName().func_110624_b()) || this.exists(block)) continue;
            this.save(block);
        }
    }

    private boolean exists(Block block) {
        return this.existingFileHelper.exists(block.getRegistryName(), ResourcePackType.CLIENT_RESOURCES, ".json", "blockstates");
    }

    private ResourceLocation prefix(String name) {
        return ElementalCraft.createRL("block/" + name);
    }

    private void save(Block block) {
        String name = block.getRegistryName().func_110623_a();
        if (block instanceof SlabBlock) {
            this.slabBlock((SlabBlock)block);
        } else if (block instanceof StairsBlock) {
            this.stairsBlock((StairsBlock)block);
        } else if (block instanceof WallBlock) {
            this.wallBlock((WallBlock)block);
        } else if (block instanceof PaneBlock) {
            this.paneBlock((PaneBlock)block);
        } else if (block instanceof BlockOverloadShrine) {
            ModelFile.ExistingModelFile base = this.models().getExistingFile(this.prefix(name + "_base"));
            ModelFile.ExistingModelFile top = this.models().getExistingFile(this.prefix(name + "_top"));
            ModelFile.ExistingModelFile side = this.models().getExistingFile(this.prefix(name + "_side"));
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)base).addModel()).end().part().modelFile((ModelFile)top).addModel()).condition((IProperty)BlockOverloadShrine.FACING, (Comparable[])new Direction[]{Direction.UP}).end().part().modelFile((ModelFile)side).addModel()).condition((IProperty)BlockOverloadShrine.FACING, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)side).rotationY(90).addModel()).condition((IProperty)BlockOverloadShrine.FACING, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)side).rotationY(180).addModel()).condition((IProperty)BlockOverloadShrine.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)side).rotationY(270).addModel()).condition((IProperty)BlockOverloadShrine.FACING, (Comparable[])new Direction[]{Direction.WEST}).end();
        } else if (block instanceof BlockTank) {
            ModelFile.ExistingModelFile base = this.models().getExistingFile(this.prefix(name));
            ModelFile.ExistingModelFile connector = this.models().getExistingFile(this.prefix(name + "_connector"));
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)base).addModel()).end().part().modelFile((ModelFile)connector).addModel()).condition((IProperty)BlockTank.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)connector).rotationY(90).addModel()).condition((IProperty)BlockTank.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)connector).rotationY(180).addModel()).condition((IProperty)BlockTank.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)connector).rotationY(270).addModel()).condition((IProperty)BlockTank.WEST, (Comparable[])new Boolean[]{true}).end();
        } else if (block instanceof BlockRetriever) {
            ModelFile.ExistingModelFile core = this.models().getExistingFile(this.prefix(name + "_core"));
            ModelFile.ExistingModelFile source = this.models().getExistingFile(this.prefix(name + "_source"));
            ModelFile.ExistingModelFile target = this.models().getExistingFile(this.prefix(name + "_target"));
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)core).addModel()).end().part().modelFile((ModelFile)source).uvLock(true).addModel()).condition((IProperty)BlockRetriever.SOURCE, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)source).rotationY(90).uvLock(true).addModel()).condition((IProperty)BlockRetriever.SOURCE, (Comparable[])new Direction[]{Direction.WEST}).end().part().modelFile((ModelFile)source).rotationY(180).uvLock(true).addModel()).condition((IProperty)BlockRetriever.SOURCE, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)source).rotationY(270).uvLock(true).addModel()).condition((IProperty)BlockRetriever.SOURCE, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)source).rotationX(270).uvLock(true).addModel()).condition((IProperty)BlockRetriever.SOURCE, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile((ModelFile)target).rotationY(180).uvLock(true).addModel()).condition((IProperty)BlockRetriever.TARGET, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)target).rotationY(270).uvLock(true).addModel()).condition((IProperty)BlockRetriever.TARGET, (Comparable[])new Direction[]{Direction.WEST}).end().part().modelFile((ModelFile)target).uvLock(true).addModel()).condition((IProperty)BlockRetriever.TARGET, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)target).rotationY(90).uvLock(true).addModel()).condition((IProperty)BlockRetriever.TARGET, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)target).rotationX(90).uvLock(true).addModel()).condition((IProperty)BlockRetriever.TARGET, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile((ModelFile)target).rotationX(270).uvLock(true).addModel()).condition((IProperty)BlockRetriever.TARGET, (Comparable[])new Direction[]{Direction.UP}).end();
        } else if (block instanceof BlockElementPipe) {
            if (block == ECBlocks.elementPipe) {
                this.pipeBlock((BlockElementPipe)block, name, "brass");
            } else if (block == ECBlocks.improvedElementPipe) {
                this.pipeBlock((BlockElementPipe)block, name, "pure_iron");
            } else {
                this.pipeBlock((BlockElementPipe)block, name, "iron");
            }
        } else if (block instanceof BlockSpellDesk) {
            ModelFile.ExistingModelFile standard = this.models().getExistingFile(this.prefix(name));
            ModelFile.ExistingModelFile withPaper = this.models().getExistingFile(this.prefix(name + "_with_paper"));
            this.horizontalBlock(block, arg_0 -> ECBlockStateProvider.lambda$save$0((ModelFile)withPaper, (ModelFile)standard, arg_0));
        } else if (block.func_176223_P().func_196959_b((IProperty)HorizontalBlock.field_185512_D)) {
            this.horizontalBlock(block, (ModelFile)this.models().getExistingFile(this.prefix(name)));
        } else if (block.func_176223_P().func_196959_b((IProperty)BlockStateProperties.field_208163_P)) {
            ModelFile.ExistingModelFile upper = this.models().getExistingFile(this.prefix(name + "_upper"));
            ModelFile.ExistingModelFile lower = this.models().getExistingFile(this.prefix(name + "_lower"));
            this.getVariantBuilder(block).partialState().with((IProperty)BlockStateProperties.field_208163_P, (Comparable)DoubleBlockHalf.UPPER).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)upper)}).partialState().with((IProperty)BlockStateProperties.field_208163_P, (Comparable)DoubleBlockHalf.LOWER).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)lower)});
        } else {
            this.simpleBlock(block, (ModelFile)this.models().getExistingFile(this.prefix(name)));
        }
    }

    @Nonnull
    public String func_200397_b() {
        return "ElementalCraft Blockstates";
    }

    private ModelFile getPipeModel(String name, String subFile, String texture) {
        return ((BlockModelBuilder)this.models().withExistingParent(name + '_' + subFile, this.prefix("template_elementpipe_" + subFile))).texture("texture", this.prefix(texture));
    }

    private void pipeBlock(BlockElementPipe block, String name, String texture) {
        ModelFile core = this.getPipeModel(name, "core", texture);
        ModelFile side = this.getPipeModel(name, "side", "iron");
        ModelFile extract = this.getPipeModel(name, "extract", "iron");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile(core).addModel()).end().part().modelFile(side).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).rotationY(90).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).rotationY(180).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).rotationY(270).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.WEST, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).rotationX(270).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.UP, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).rotationX(90).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.DOWN, (Comparable[])new Boolean[]{true}).end().part().modelFile(extract).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.NORTH_EXTRACT, (Comparable[])new Boolean[]{true}).end().part().modelFile(extract).rotationY(90).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.EAST_EXTRACT, (Comparable[])new Boolean[]{true}).end().part().modelFile(extract).rotationY(180).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.SOUTH_EXTRACT, (Comparable[])new Boolean[]{true}).end().part().modelFile(extract).rotationY(270).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.WEST_EXTRACT, (Comparable[])new Boolean[]{true}).end().part().modelFile(extract).rotationX(270).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.UP_EXTRACT, (Comparable[])new Boolean[]{true}).end().part().modelFile(extract).rotationX(90).uvLock(true).addModel()).condition((IProperty)BlockElementPipe.DOWN_EXTRACT, (Comparable[])new Boolean[]{true}).end();
    }

    private void slabBlock(SlabBlock block) {
        String name = block.getRegistryName().func_110623_a();
        ResourceLocation sourceName = this.prefix(name.substring(0, name.length() - 5));
        ModelBuilder bottom = this.models().slab(name, sourceName, sourceName, sourceName);
        ModelBuilder top = this.models().slabTop(name + "_top", sourceName, sourceName, sourceName);
        ModelFile.ExistingModelFile full = this.models().getExistingFile(sourceName);
        this.slabBlock(block, (ModelFile)bottom, (ModelFile)top, (ModelFile)full);
    }

    private void stairsBlock(StairsBlock block) {
        String name = block.getRegistryName().func_110623_a();
        ResourceLocation sourceName = this.prefix(name.substring(0, name.length() - 7));
        ModelBuilder stair = this.models().stairs(name, sourceName, sourceName, sourceName);
        ModelBuilder inner = this.models().stairsInner(name + "_inner", sourceName, sourceName, sourceName);
        ModelBuilder outer = this.models().stairsOuter(name + "_outer", sourceName, sourceName, sourceName);
        this.stairsBlock(block, (ModelFile)stair, (ModelFile)inner, (ModelFile)outer);
    }

    private void wallBlock(WallBlock block) {
        String name = block.getRegistryName().func_110623_a();
        ResourceLocation sourceName = this.prefix(name.substring(0, name.length() - 5));
        ModelBuilder post = this.models().wallPost(name + "_post", sourceName);
        ModelBuilder side = this.models().wallSide(name + "_side", sourceName);
        this.wallBlock(block, (ModelFile)post, (ModelFile)side);
    }

    private void paneBlock(PaneBlock block) {
        String name = block.getRegistryName().func_110623_a();
        ResourceLocation sourceName = this.prefix(name.substring(0, name.length() - 5));
        this.paneBlock(block, sourceName, sourceName);
    }

    private static /* synthetic */ ModelFile lambda$save$0(ModelFile withPaper, ModelFile standard, BlockState s) {
        return Boolean.TRUE.equals(s.func_177229_b((IProperty)BlockSpellDesk.HAS_PAPER)) ? withPaper : standard;
    }
}

