/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data;

import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.item.holder.ItemElementHolder;

public class ECItemModelProvider
extends ItemModelProvider {
    public ECItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "elementalcraft", existingFileHelper);
    }

    protected void registerModels() {
        for (Item item : ForgeRegistries.ITEMS) {
            if (!"elementalcraft".equals(item.getRegistryName().func_110624_b()) || this.exists(item)) continue;
            String name = item.getRegistryName().func_110623_a();
            if (item instanceof BlockItem) {
                ResourceLocation parent = ElementalCraft.createRL("block/" + name);
                if (this.exists(parent)) {
                    this.withExistingParent(name, parent);
                    continue;
                }
                ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(parent));
                continue;
            }
            if (item instanceof ItemElementHolder) {
                this.withExistingParent(name, ElementalCraft.createRL("item/template_element_holder"));
                continue;
            }
            this.singleTexture(name, new ResourceLocation("minecraft", "item/generated"), ElementalCraft.createRL("item/" + name));
        }
    }

    private boolean exists(Item item) {
        return this.existingFileHelper.exists(item.getRegistryName(), ResourcePackType.CLIENT_RESOURCES, ".json", "models/item");
    }

    private boolean exists(ResourceLocation model) {
        return this.existingFileHelper.exists(model, ResourcePackType.CLIENT_RESOURCES, ".json", "models");
    }

    @Nonnull
    public String func_200397_b() {
        return "ElementalCraft item models";
    }
}

