/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.loot;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.MatchTool;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.CopyNbt;
import net.minecraft.world.storage.loot.functions.ExplosionDecay;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.registries.ForgeRegistries;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.pureinfuser.BlockPedestal;
import sirttas.elementalcraft.block.shrine.BlockPylonShrine;
import sirttas.elementalcraft.block.shrine.TileShrine;
import sirttas.elementalcraft.block.shrine.firepylon.BlockFirePylon;
import sirttas.elementalcraft.block.spelldesk.BlockSpellDesk;
import sirttas.elementalcraft.data.loot.AbstractECLootProvider;
import sirttas.elementalcraft.item.ECItems;

public class ECBlockLootProvider
extends AbstractECLootProvider {
    private final Map<Block, Function<IItemProvider, LootTable.Builder>> functionTable = new HashMap<Block, Function<IItemProvider, LootTable.Builder>>();

    public ECBlockLootProvider(DataGenerator generator) {
        super(generator);
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!"elementalcraft".equals(block.getRegistryName().func_110624_b())) continue;
            if (block instanceof SlabBlock) {
                this.functionTable.put(block, ECBlockLootProvider::genSlab);
                continue;
            }
            if (block instanceof BlockPylonShrine) {
                this.functionTable.put(block, ECBlockLootProvider::genPylonShrine);
                continue;
            }
            if (this.isTileInstanceOf(block, TileShrine.class)) {
                this.functionTable.put(block, i -> ECBlockLootProvider.genCopyNbt(i, "element_type", "element_amount"));
                continue;
            }
            if (block instanceof BlockPedestal) {
                this.functionTable.put(block, i -> ECBlockLootProvider.genCopyNbt(i, "element_amount"));
                continue;
            }
            if (!(block instanceof BlockSpellDesk)) continue;
            this.functionTable.put(block, ECBlockLootProvider::genSpellDesk);
        }
        this.functionTable.put(ECBlocks.crystalOre, i -> ECBlockLootProvider.genOre(ECItems.inertCrystal));
        this.functionTable.put(ECBlocks.tank, i -> ECBlockLootProvider.genCopyNbt(i, "element_type", "element_amount", "element_max", "small"));
        this.functionTable.put(ECBlocks.tankSmall, i -> ECBlockLootProvider.genCopyNbt(i, "element_type", "element_amount", "element_max", "small"));
        this.functionTable.put(ECBlocks.burntGlass, ECBlockLootProvider::genOnlySilkTouch);
        this.functionTable.put((Block)ECBlocks.burntGlassPane, ECBlockLootProvider::genOnlySilkTouch);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!"elementalcraft".equals(block.getRegistryName().func_110624_b())) continue;
            this.save(cache, block);
        }
    }

    private boolean isTileInstanceOf(Block block, Class<?> clazz) {
        return block.hasTileEntity(block.func_176223_P()) && clazz.isAssignableFrom(block.func_176223_P().createTileEntity(null).getClass());
    }

    private void save(DirectoryCache cache, Block block) throws IOException {
        Function<IItemProvider, LootTable.Builder> func = this.functionTable.get(block);
        LootTable.Builder builder = func != null ? func.apply((IItemProvider)block) : ECBlockLootProvider.genRegular((IItemProvider)block);
        this.save(cache, builder.func_216039_a(LootParameterSets.field_216267_h), ECBlockLootProvider.getPath(this.generator.func_200391_b(), block.getRegistryName()));
    }

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.func_110624_b() + "/loot_tables/blocks/" + id.func_110623_a() + ".json");
    }

    private static LootTable.Builder genRegular(IItemProvider item) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)item);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genSpellDesk(IItemProvider block) {
        return ECBlockLootProvider.genRegular(block).func_216040_a(LootPool.func_216096_a().name("paper").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151121_aF)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)block)).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227195_a_((IProperty)BlockSpellDesk.HAS_PAPER, true))));
    }

    private static LootTable.Builder genOnlySilkTouch(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item)));
    }

    private static LootTable.Builder genOre(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)))))).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t)).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()))));
    }

    private static LootTable.Builder genCopyNbt(IItemProvider item, String ... tags) {
        return ECBlockLootProvider.genCopyNbt(ItemLootEntry.func_216168_a((IItemProvider)item), tags);
    }

    private static LootTable.Builder genPylonShrine(IItemProvider item) {
        LootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)item).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)item)).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(BlockFirePylon.HALF, (Comparable)DoubleBlockHalf.LOWER)));
        return ECBlockLootProvider.genCopyNbt(entry, "element_type", "element_amount");
    }

    private static LootTable.Builder genCopyNbt(LootEntry.Builder<?> entry, String ... tags) {
        CopyNbt.Builder func = CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY);
        for (String tag : tags) {
            func = func.func_216056_a(tag, "BlockEntityTag." + tag);
        }
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(entry).func_212840_b_(SurvivesExplosion.func_215968_b()).func_212841_b_((ILootFunction.IBuilder)func);
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genSlab(IItemProvider item) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)item)).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b());
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry));
    }

    public String func_200397_b() {
        return "ElementalCraft block loot tables";
    }
}

