/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.recipe.builder;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.recipe.instrument.infusion.InfusionRecipe;

public class InfusionRecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final ElementType elementType;
    private int consumption;
    private int duration;
    private final IRecipeSerializer<?> serializer;

    public InfusionRecipeBuilder(IRecipeSerializer<?> serializerIn, Ingredient ingredientIn, IItemProvider resultProviderIn, ElementType elementType) {
        this.serializer = serializerIn;
        this.result = resultProviderIn.func_199767_j();
        this.ingredient = ingredientIn;
        this.elementType = elementType;
        this.consumption = 0;
        this.duration = 0;
    }

    public static InfusionRecipeBuilder infusionRecipe(Ingredient ingredientIn, IItemProvider resultIn, ElementType elementType) {
        return new InfusionRecipeBuilder(InfusionRecipe.SERIALIZER, ingredientIn, resultIn, elementType);
    }

    public InfusionRecipeBuilder withConsumption(int consumption) {
        this.consumption = consumption;
        return this;
    }

    public InfusionRecipeBuilder withDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Infusion Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.serializer, this.ingredient, this.result, this.elementType, this.consumption, this.duration));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Item output;
        private final ElementType elementType;
        private final int consumption;
        private final int duration;
        private final IRecipeSerializer<?> serializer;

        public Result(ResourceLocation idIn, IRecipeSerializer<?> serializerIn, Ingredient ingredientIn, Item resultIn, ElementType elementType, int consumption, int duration) {
            this.id = idIn;
            this.serializer = serializerIn;
            this.ingredient = ingredientIn;
            this.output = resultIn;
            this.elementType = elementType;
            this.consumption = consumption;
            this.duration = duration;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("element", this.elementType.func_176610_l());
            if (this.consumption > 0) {
                json.addProperty("consumption", (Number)this.consumption);
            }
            if (this.duration > 0) {
                json.addProperty("duration", (Number)this.duration);
            }
            json.add("input", this.ingredient.func_200304_c());
            json.addProperty("output", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output).toString());
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

