/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.recipe.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.recipe.PureInfusionRecipe;

public class PureInfusionRecipeBuilder {
    private final Item result;
    private final List<Ingredient> ingredients = Lists.newArrayList((Object[])new Ingredient[]{Ingredient.field_193370_a, Ingredient.field_193370_a, Ingredient.field_193370_a, Ingredient.field_193370_a, Ingredient.field_193370_a});
    private int consumption;
    private int duration;
    private final IRecipeSerializer<?> serializer;

    public PureInfusionRecipeBuilder(IRecipeSerializer<?> serializerIn, IItemProvider resultProviderIn) {
        this.serializer = serializerIn;
        this.result = resultProviderIn.func_199767_j();
        this.consumption = 0;
        this.duration = 0;
    }

    public static PureInfusionRecipeBuilder pureInfusionRecipe(IItemProvider resultIn) {
        return new PureInfusionRecipeBuilder(PureInfusionRecipe.SERIALIZER, resultIn);
    }

    public PureInfusionRecipeBuilder withConsumption(int consumption) {
        this.consumption = consumption;
        return this;
    }

    public PureInfusionRecipeBuilder withDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public PureInfusionRecipeBuilder setIngredient(Tag<Item> tagIn) {
        return this.setIngredient(ElementType.NONE, Ingredient.func_199805_a(tagIn));
    }

    public PureInfusionRecipeBuilder setIngredient(IItemProvider itemIn) {
        return this.setIngredient(ElementType.NONE, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public PureInfusionRecipeBuilder setIngredient(Ingredient ingredientIn) {
        return this.setIngredient(ElementType.NONE, ingredientIn);
    }

    public PureInfusionRecipeBuilder setIngredient(ElementType type, Tag<Item> tagIn) {
        return this.setIngredient(type, Ingredient.func_199805_a(tagIn));
    }

    public PureInfusionRecipeBuilder setIngredient(ElementType type, IItemProvider itemIn) {
        return this.setIngredient(type, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public PureInfusionRecipeBuilder setIngredient(ElementType type, Ingredient ingredientIn) {
        int index = type == ElementType.NONE ? 0 : (type == ElementType.WATER ? 1 : (type == ElementType.FIRE ? 2 : (type == ElementType.EARTH ? 3 : (type == ElementType.AIR ? 4 : -1))));
        this.ingredients.set(index, ingredientIn);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Binding Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.serializer, this.ingredients, this.result, this.consumption, this.duration));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final List<Ingredient> ingredients;
        private final Item output;
        private final int consumption;
        private final int duration;
        private final IRecipeSerializer<?> serializer;

        public Result(ResourceLocation idIn, IRecipeSerializer<?> serializerIn, List<Ingredient> ingredients, Item resultIn, int consumption, int duration) {
            this.id = idIn;
            this.serializer = serializerIn;
            this.ingredients = ingredients;
            this.output = resultIn;
            this.consumption = consumption;
            this.duration = duration;
        }

        public void func_218610_a(JsonObject json) {
            if (this.consumption > 0) {
                json.addProperty("consumption", (Number)this.consumption);
            }
            if (this.duration > 0) {
                json.addProperty("duration", (Number)this.duration);
            }
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            json.addProperty("output", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output).toString());
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

