/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity;

import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import sirttas.elementalcraft.infusion.InfusionHelper;
import sirttas.elementalcraft.network.message.ECMessage;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class EntityHandler {
    private static boolean lastJump = false;

    @SubscribeEvent
    public static void onEntityUseItemTick(LivingEntityUseItemEvent.Tick event) {
        if (InfusionHelper.hasAirInfusionFasterDraw(event.getItem()) && event.getDuration() % 3 == 0) {
            event.setDuration(event.getDuration() - 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientAirInfusionFly(ClientPlayerEntity player) {
        if (InfusionHelper.canAirInfusionFly((PlayerEntity)player) && (player.func_184613_cA() || player.field_71158_b.field_78901_c && !lastJump && !player.func_184613_cA())) {
            player.func_226567_ej_();
            ECMessage.AIR_INFUSION.send();
        } else {
            player.func_226568_ek_();
        }
        lastJump = player.field_71158_b.field_78901_c || player.field_70122_E;
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (entity instanceof ClientPlayerEntity) {
                EntityHandler.clientAirInfusionFly((ClientPlayerEntity)event.getEntityLiving());
            }
        });
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            if (player.func_184613_cA() && InfusionHelper.canAirInfusionFly((PlayerEntity)player)) {
                player.func_226567_ej_();
            } else {
                player.func_226568_ek_();
            }
        }
    }
}

