/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.tile.element.IElementStorage;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.gui.GuiHelper;
import sirttas.elementalcraft.item.holder.ItemElementHolder;
import sirttas.elementalcraft.item.spell.ISpellHolder;
import sirttas.elementalcraft.spell.SpellHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft")
public class GuiHandler {
    @SubscribeEvent
    public static void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        RayTraceResult result = minecraft.field_71476_x;
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ItemStack stack;
            if (result != null) {
                IElementStorage storage;
                TileEntity tile;
                BlockPos pos = result.func_216346_c() == RayTraceResult.Type.BLOCK ? ((BlockRayTraceResult)result).func_216350_a() : null;
                TileEntity tileEntity = tile = pos != null ? minecraft.field_71441_e.func_175625_s(pos) : null;
                if (tile instanceof IElementStorage && ((storage = (IElementStorage)tile).doesRenderGauge() || GuiHelper.showDebugInfo())) {
                    GuiHandler.doRenderElementGauge(storage.getElementAmount(), storage.getMaxElement(), storage.getElementType());
                    return;
                }
            }
            if (!(stack = GuiHandler.getElementHolder()).func_190926_b() && stack.func_77973_b() instanceof ItemElementHolder) {
                ItemElementHolder holder = (ItemElementHolder)stack.func_77973_b();
                GuiHandler.doRenderElementGauge(holder.getElementAmount(stack), holder.getElementAmountMax(), holder.getElementType());
            }
        }
    }

    private static ItemStack getElementHolder() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return EntityHelper.handStream((PlayerEntity)player).map(s -> {
            if (!s.func_190926_b() && s.func_77973_b() instanceof ItemElementHolder) {
                return s;
            }
            if (!s.func_190926_b() && s.func_77973_b() instanceof ISpellHolder) {
                return ItemElementHolder.find((PlayerEntity)player, SpellHelper.getSpell(s).getElementType());
            }
            return ItemStack.field_190927_a;
        }).filter(s -> !s.func_190926_b()).findFirst().orElse(ItemStack.field_190927_a);
    }

    private static void doRenderElementGauge(int element, int max, ElementType type) {
        GuiHelper.renderElementGauge(Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 - 32, Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 2 - 8, element, max, type);
    }
}

