/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.holder;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.tile.TileEntityHelper;
import sirttas.elementalcraft.block.tile.element.IElementReceiver;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.ItemEC;
import sirttas.elementalcraft.item.receptacle.ISourceInteractable;
import sirttas.elementalcraft.property.ECProperties;

public class ItemElementHolder
extends ItemEC
implements ISourceInteractable {
    public static final String NAME = "element_holder";
    public static final String NAME_FIRE = "element_holder_fire";
    public static final String NAME_WATER = "element_holder_water";
    public static final String NAME_EARTH = "element_holder_earth";
    public static final String NAME_AIR = "element_holder_air";
    private final ElementType elementType;
    private final int elementAmountMax;

    public ItemElementHolder(ElementType elementType) {
        super(ECProperties.Items.ITEM_UNSTACKABLE);
        this.elementType = elementType;
        this.elementAmountMax = (Integer)ECConfig.CONFIG.elementHolderMaxAmount.get();
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public int getElementAmountMax() {
        return this.elementAmountMax;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    protected boolean isValidSource(BlockState state) {
        return state.func_177230_c().equals(ECBlocks.source) && state.func_177229_b(ECProperties.ELEMENT_TYPE) == this.elementType;
    }

    @Override
    public boolean canIteractWithSource(ItemStack stack, BlockState state) {
        return this.isValidSource(state);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        ItemStack stack = context.func_195996_i();
        if (this.isValidSource(blockstate)) {
            this.inserElement(stack, (Integer)ECConfig.CONFIG.elementHolderTransferAmount.get());
            return ActionResultType.SUCCESS;
        }
        return TileEntityHelper.getTileEntityAs((IBlockReader)context.func_195991_k(), context.func_195995_a(), IElementReceiver.class).map(r -> {
            int amount = Math.min(this.getElementAmount(stack), (Integer)ECConfig.CONFIG.elementHolderTransferAmount.get());
            if (r.getElementType() == this.elementType && (amount -= r.inserElement(amount, this.elementType, true)) > 0) {
                this.extractElement(stack, amount);
                r.inserElement(amount, this.elementType, false);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }).orElse(ActionResultType.PASS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("tooltip.elementalcraft.percent_full", new Object[]{ItemStack.field_111284_a.format(this.getElementAmount(stack) * 100 / this.elementAmountMax)}).func_211708_a(TextFormatting.GREEN));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack full = new ItemStack((IItemProvider)this);
            this.setElementAmount(full, this.elementAmountMax);
            items.add((Object)new ItemStack((IItemProvider)this));
            items.add((Object)full);
        }
    }

    public int getDamage(ItemStack stack) {
        return 1000 * (this.elementAmountMax - this.getElementAmount(stack)) / this.elementAmountMax;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1000;
    }

    public int getElementAmount(ItemStack stack) {
        return stack.func_77978_p() == null ? 0 : stack.func_77978_p().func_74762_e("element_amount");
    }

    public void setElementAmount(ItemStack stack, int amount) {
        stack.func_196082_o().func_74768_a("element_amount", Math.min(amount, this.elementAmountMax));
    }

    public int inserElement(ItemStack stack, int amount) {
        int elementAmount = this.getElementAmount(stack);
        int newCount = Math.min(elementAmount + amount, this.elementAmountMax);
        int ret = amount - newCount + elementAmount;
        this.setElementAmount(stack, newCount);
        return ret;
    }

    public int extractElement(ItemStack stack, int amount) {
        int elementAmount = this.getElementAmount(stack);
        int newCount = Math.max(elementAmount - amount, 0);
        int ret = elementAmount - newCount;
        this.setElementAmount(stack, newCount);
        return ret;
    }

    public static ItemStack find(PlayerEntity player, ElementType elementType) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemElementHolder) || ((ItemElementHolder)item).getElementType() != elementType) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

