/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell;

import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.ItemEC;
import sirttas.elementalcraft.item.spell.ISpellHolder;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.SpellTickManager;

public abstract class AbstractItemSpellHolder
extends ItemEC
implements ISpellHolder {
    public AbstractItemSpellHolder(Item.Properties properties) {
        super(properties);
    }

    protected void addAttributeTooltip(List<ITextComponent> tooltip, Spell spell) {
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add(new TranslationTextComponent("tooltip.elementalcraft.consumes", new Object[]{spell.getElementType().getDisplayName()}).func_211708_a(TextFormatting.YELLOW));
        spell.addInformation(tooltip);
        AbstractItemSpellHolder.addAttributeMultimapToTooltip(tooltip, spell.getOnUseAttributeModifiers(), new TranslationTextComponent("tooltip.elementalcraft.on_spell_use", new Object[0]).func_211708_a(TextFormatting.GRAY));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Spell spell = SpellHelper.getSpell(stack);
        Multimap<String, AttributeModifier> attributes = spell.getOnUseAttributeModifiers();
        playerIn.func_110140_aT().func_111147_b(attributes);
        ActionResultType result = this.castSpell(playerIn, spell, EntityHelper.rayTrace((Entity)playerIn, playerIn.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e()));
        if (result.func_226246_a_() && !playerIn.func_184812_l_()) {
            if (!spell.consume((Entity)playerIn)) {
                this.consume(stack);
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> playerIn.func_70669_a(stack));
            }
            if (result.func_226247_b_()) {
                SpellTickManager.getInstance(worldIn).setCooldown((Entity)playerIn, spell);
            }
        }
        playerIn.func_110140_aT().func_111148_a(attributes);
        return new ActionResult(result, (Object)stack);
    }

    private ActionResultType castSpell(PlayerEntity playerIn, Spell spell, RayTraceResult ray) {
        ActionResultType result = ActionResultType.PASS;
        if (SpellTickManager.getInstance(playerIn.field_70170_p).hasCooldown((Entity)playerIn, spell)) {
            return result;
        }
        if (ray.func_216346_c() == RayTraceResult.Type.ENTITY) {
            result = spell.castOnEntity((Entity)playerIn, ((EntityRayTraceResult)ray).func_216348_a());
        }
        if (ray.func_216346_c() == RayTraceResult.Type.BLOCK && !result.func_226246_a_()) {
            result = spell.castOnBlock((Entity)playerIn, ((BlockRayTraceResult)ray).func_216350_a());
        }
        if (!result.func_226246_a_()) {
            result = spell.castOnSelf((Entity)playerIn);
        }
        return result;
    }

    protected abstract void consume(ItemStack var1);

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        return SpellHelper.getSpell(stack).getAttributeModifiers(equipmentSlot);
    }
}

