/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.instrument.purifier.TilePurifier;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.jei.category.AbstractInstrumentRecipeCategory;
import sirttas.elementalcraft.recipe.instrument.PurifierRecipe;

public class PurificationRecipeCategory
extends AbstractInstrumentRecipeCategory<TilePurifier, PurifierRecipe> {
    public static final ResourceLocation UID = ElementalCraft.createRL("purification");
    private final IDrawable icon;
    private final IDrawable overlay;
    private final IDrawable background;
    private ItemStack purifier = new ItemStack((IItemProvider)ECItems.purifier).func_77946_l();

    public PurificationRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(75, 59);
        this.icon = guiHelper.createDrawableIngredient((Object)this.purifier);
        this.overlay = guiHelper.createDrawable(ElementalCraft.createRL("textures/gui/infusion_overlay.png"), 0, 0, 65, 16);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends PurifierRecipe> getRecipeClass() {
        return PurifierRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"elementalcraft.jei.purification", (Object[])new Object[0]);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(PurifierRecipe recipe, double mouseX, double mouseY) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(8, 20);
        this.renderElementGauge(31, 42, recipe);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
    }

    public void setRecipe(IRecipeLayout recipeLayout, PurifierRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(1, false, 30, 24);
        recipeLayout.getItemStacks().set(1, this.tank);
        recipeLayout.getItemStacks().init(2, false, 30, 8);
        recipeLayout.getItemStacks().set(2, this.purifier);
        recipeLayout.getItemStacks().init(3, false, 59, 0);
        recipeLayout.getItemStacks().set(3, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

