/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sirttas.elementalcraft.infusion.InfusionHelper;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FireInfusionLootModifier
extends LootModifier {
    protected FireInfusionLootModifier(ILootCondition[] conditions) {
        super(conditions);
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<GlobalLootModifierSerializer<?>> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)new Serializer().setRegistryName("elementalcraft", "fireinfusion"));
    }

    private ItemStack applyAutoSmelt(ItemStack stack, ServerWorld world) {
        Optional<IRecipe> recipe = world.func_199532_z().func_215366_a(IRecipeType.field_222150_b).values().stream().filter(r -> ((Ingredient)r.func_192400_c().get(0)).test(stack)).findFirst();
        if (recipe.isPresent()) {
            ItemStack ret = recipe.get().func_77571_b().func_77946_l();
            ret.func_190920_e(ret.func_190916_E() * stack.func_190916_E());
            return ret;
        }
        return stack;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (tool != null && !tool.func_190926_b() && InfusionHelper.hasFireInfusionAutoSmelt(tool)) {
            return generatedLoot.stream().map(s -> this.applyAutoSmelt((ItemStack)s, context.func_202879_g())).collect(Collectors.toList());
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<FireInfusionLootModifier> {
        public FireInfusionLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            return new FireInfusionLootModifier(conditions);
        }
    }
}

