/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.pureinfuser.TilePureInfuser;
import sirttas.elementalcraft.recipe.IInventoryTileRecipe;

public class PureInfusionRecipe
implements IInventoryTileRecipe<TilePureInfuser> {
    public static final String NAME = "pureinfusion";
    public static final IRecipeType<PureInfusionRecipe> TYPE = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation("pureinfusion"), (Object)new IRecipeType<PureInfusionRecipe>(){

        public String toString() {
            return PureInfusionRecipe.NAME;
        }
    });
    @ObjectHolder(value="elementalcraft:pureinfusion")
    public static IRecipeSerializer<PureInfusionRecipe> SERIALIZER;
    private NonNullList<Ingredient> ingredients;
    private ItemStack output;
    private int elementPerTick;
    private int duration;
    private ResourceLocation id;

    public PureInfusionRecipe(ResourceLocation id, int elementPerTick, int duration, ItemStack output, List<Ingredient> ingredients) {
        this.id = id;
        this.ingredients = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])((Ingredient[])ingredients.stream().toArray(Ingredient[]::new)));
        this.output = output;
        this.elementPerTick = elementPerTick;
        this.duration = duration;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    @Override
    public boolean matches(TilePureInfuser inv) {
        return ((Ingredient)this.ingredients.get(0)).test(inv.getItem()) && ((Ingredient)this.ingredients.get(1)).test(inv.getStackInPedestal(ElementType.WATER)) && ((Ingredient)this.ingredients.get(2)).test(inv.getStackInPedestal(ElementType.FIRE)) && ((Ingredient)this.ingredients.get(3)).test(inv.getStackInPedestal(ElementType.EARTH)) && ((Ingredient)this.ingredients.get(4)).test(inv.getStackInPedestal(ElementType.AIR));
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public ItemStack getCraftingResult(TilePureInfuser inv) {
        return this.func_77571_b().func_77946_l();
    }

    @Override
    public void process(TilePureInfuser instrument) {
        instrument.getInventory().func_70299_a(0, this.getCraftingResult(instrument));
        instrument.emptyPedestals();
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public int getElementPerTick() {
        return this.elementPerTick;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PureInfusionRecipe> {
        final IRecipeFactory factory;

        public Serializer(IRecipeFactory factory) {
            this.factory = factory;
        }

        public PureInfusionRecipe read(ResourceLocation recipeId, JsonObject json) {
            int elementPerTick = JSONUtils.func_151208_a((JsonObject)json, (String)"consumption", (int)100);
            int duration = JSONUtils.func_151208_a((JsonObject)json, (String)"duration", (int)600);
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            ItemStack output = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"output"))));
            return this.factory.create(recipeId, elementPerTick, duration, output, (List<Ingredient>)ingredients);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray json) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < json.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public PureInfusionRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int elementPerTick = buffer.readInt();
            int duration = buffer.readInt();
            ItemStack output = buffer.func_150791_c();
            int i = buffer.func_150792_a();
            NonNullList ingredients = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return this.factory.create(recipeId, elementPerTick, duration, output, (List<Ingredient>)ingredients);
        }

        public void write(PacketBuffer buffer, PureInfusionRecipe recipe) {
            buffer.writeInt(recipe.getElementPerTick());
            buffer.writeInt(recipe.getDuration());
            buffer.func_150788_a(recipe.func_77571_b());
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
        }

        public static interface IRecipeFactory {
            public PureInfusionRecipe create(ResourceLocation var1, int var2, int var3, ItemStack var4, List<Ingredient> var5);
        }
    }
}

