/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.instrument.binder.TileBinder;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;

public class BinderRecipe
extends AbstractInstrumentRecipe<TileBinder> {
    public static final String NAME = "binding";
    public static final IRecipeType<BinderRecipe> TYPE = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation("binding"), (Object)new IRecipeType<BinderRecipe>(){

        public String toString() {
            return BinderRecipe.NAME;
        }
    });
    @ObjectHolder(value="elementalcraft:binding")
    public static IRecipeSerializer<BinderRecipe> SERIALIZER;
    private NonNullList<Ingredient> ingredients;
    private ItemStack output;
    private int elementPerTick;
    private int duration;

    public BinderRecipe(ResourceLocation id, ElementType type, int elementPerTick, int duration, ItemStack output, List<Ingredient> ingredients) {
        super(id, type);
        this.ingredients = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])((Ingredient[])ingredients.stream().toArray(Ingredient[]::new)));
        this.output = output;
        this.elementPerTick = elementPerTick;
        this.duration = duration;
    }

    @Override
    public int getElementPerTick() {
        return this.elementPerTick;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public boolean matches(TileBinder inv) {
        if (inv.getItemCount() != this.ingredients.size()) {
            return false;
        }
        return Boolean.TRUE.equals(ECConfig.CONFIG.binderRecipeMatchOrder.get()) ? this.matchesOrdered(inv) : this.matchesUnordered(inv);
    }

    private boolean matchesOrdered(TileBinder inv) {
        for (int i = 0; i < inv.getItemCount(); ++i) {
            if (((Ingredient)this.ingredients.get(i)).test(inv.getInventory().func_70301_a(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matchesUnordered(TileBinder inv) {
        return this.ingredients.stream().allMatch(ing -> {
            for (int i = 0; i < inv.getItemCount(); ++i) {
                if (!ing.test(inv.getInventory().func_70301_a(i))) continue;
                return true;
            }
            return false;
        });
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    @Override
    public void process(TileBinder instrument) {
        instrument.func_174888_l();
        super.process(instrument);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BinderRecipe> {
        final IRecipeFactory factory;

        public Serializer(IRecipeFactory factory) {
            this.factory = factory;
        }

        public BinderRecipe read(ResourceLocation recipeId, JsonObject json) {
            ElementType type = ElementType.byName(JSONUtils.func_151200_h((JsonObject)json, (String)"element"));
            int elementPerTick = JSONUtils.func_151208_a((JsonObject)json, (String)"consumption", (int)25);
            int duration = JSONUtils.func_151208_a((JsonObject)json, (String)"duration", (int)100);
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            ItemStack output = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"output"))));
            return this.factory.create(recipeId, type, elementPerTick, duration, output, (List<Ingredient>)ingredients);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray json) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < json.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public BinderRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ElementType type = ElementType.byName(buffer.func_150789_c(Short.MAX_VALUE));
            int elementPerTick = buffer.readInt();
            int duration = buffer.readInt();
            ItemStack output = buffer.func_150791_c();
            int i = buffer.func_150792_a();
            NonNullList ingredients = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return this.factory.create(recipeId, type, elementPerTick, duration, output, (List<Ingredient>)ingredients);
        }

        public void write(PacketBuffer buffer, BinderRecipe recipe) {
            buffer.func_180714_a(recipe.getElementType().func_176610_l());
            buffer.writeInt(recipe.getElementPerTick());
            buffer.writeInt(recipe.getDuration());
            buffer.func_150788_a(recipe.func_77571_b());
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
        }

        public static interface IRecipeFactory {
            public BinderRecipe create(ResourceLocation var1, ElementType var2, int var3, int var4, ItemStack var5, List<Ingredient> var6);
        }
    }
}

