/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.instrument.purifier.TilePurifier;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.pureore.PureOreHelper;
import sirttas.elementalcraft.recipe.instrument.IInstrumentRecipe;

public class PurifierRecipe
implements IInstrumentRecipe<TilePurifier> {
    private final ResourceLocation id;
    private final ItemStack ore;
    protected Ingredient input;

    public PurifierRecipe(ItemStack ore) {
        ResourceLocation oreName = ore.func_77973_b().getRegistryName();
        this.ore = ore;
        this.input = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ore});
        this.id = ElementalCraft.createRL(oreName.func_110624_b() + '_' + oreName.func_110623_a() + "_to_pure_ore");
    }

    @Override
    public int getElementPerTick() {
        return (Integer)ECConfig.CONFIG.purifierConsumeAmount.get();
    }

    @Override
    public int getDuration() {
        return (Integer)ECConfig.CONFIG.purifierDuration.get();
    }

    @Override
    public boolean matches(TilePurifier inv) {
        ItemStack stack = inv.getInventory().func_70301_a(0);
        return inv.getTankElementType() == ElementType.EARTH && PureOreHelper.isValidOre(stack) && this.input.test(stack);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.input});
    }

    public ItemStack func_77571_b() {
        ItemStack result = PureOreHelper.createPureOre(this.ore.func_77973_b()).func_77946_l();
        result.func_190920_e(2);
        return result;
    }

    public IRecipeType<?> func_222127_g() {
        return null;
    }

    @Override
    public ElementType getElementType() {
        return ElementType.EARTH;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public void process(TilePurifier instrument) {
        IInventory inv = instrument.getInventory();
        ItemStack in = inv.func_70301_a(0);
        ItemStack output = inv.func_70301_a(1);
        ItemStack result = this.getCraftingResult(instrument);
        if (result.func_77969_a(output) && output.func_190916_E() + result.func_190916_E() <= output.func_77976_d()) {
            in.func_190918_g(1);
            output.func_190917_f(result.func_190916_E());
        } else if (output.func_190926_b()) {
            in.func_190918_g(1);
            inv.func_70299_a(1, result.func_77946_l());
        }
        if (in.func_190926_b()) {
            inv.func_70304_b(0);
        }
    }

    public IRecipeSerializer<?> func_199559_b() {
        return null;
    }
}

