/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.infusion;

import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.instrument.infuser.TileInfuser;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.infusion.AbstractInfusionRecipe;

public class InfusionRecipe
extends AbstractInfusionRecipe {
    public static final String NAME = "infusion";
    @ObjectHolder(value="elementalcraft:infusion")
    public static IRecipeSerializer<InfusionRecipe> SERIALIZER;
    private Ingredient input;
    private ItemStack output;
    private int elementPerTick;
    private int duration;

    public InfusionRecipe(ResourceLocation id, ElementType type, int elementPerTick, int duration, ItemStack output, Ingredient input) {
        super(id, type);
        this.input = input;
        this.output = output;
        this.elementPerTick = elementPerTick;
        this.duration = duration;
    }

    @Override
    public int getElementPerTick() {
        return this.elementPerTick;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public boolean matches(TileInfuser inv) {
        ItemStack stack = inv.getItem();
        if (super.matches(inv) && inv.getTankElementType() == this.getElementType()) {
            return this.input.test(stack);
        }
        return false;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.input});
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InfusionRecipe> {
        final IRecipeFactory factory;

        public Serializer(IRecipeFactory factory) {
            this.factory = factory;
        }

        public InfusionRecipe read(ResourceLocation recipeId, JsonObject json) {
            ElementType type = ElementType.byName(JSONUtils.func_151200_h((JsonObject)json, (String)"element"));
            int elementPerTick = JSONUtils.func_151208_a((JsonObject)json, (String)"consumption", (int)10);
            int duration = JSONUtils.func_151208_a((JsonObject)json, (String)"duration", (int)100);
            Ingredient input = RecipeHelper.deserializeIngredient(json, "input");
            ItemStack output = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"output"))));
            return this.factory.create(recipeId, type, elementPerTick, duration, output, input);
        }

        public InfusionRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ElementType type = ElementType.byName(buffer.func_150789_c(Short.MAX_VALUE));
            int elementPerTick = buffer.readInt();
            int duration = buffer.readInt();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            return this.factory.create(recipeId, type, elementPerTick, duration, output, input);
        }

        public void write(PacketBuffer buffer, InfusionRecipe recipe) {
            buffer.func_180714_a(recipe.getElementType().func_176610_l());
            buffer.writeInt(recipe.getElementPerTick());
            buffer.writeInt(recipe.getDuration());
            ((Ingredient)recipe.func_192400_c().get(0)).func_199564_a(buffer);
            buffer.func_150788_a(recipe.func_77571_b());
        }

        public static interface IRecipeFactory {
            public InfusionRecipe create(ResourceLocation var1, ElementType var2, int var3, int var4, ItemStack var5, Ingredient var6);
        }
    }
}

