/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.infusion;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.instrument.infuser.TileInfuser;
import sirttas.elementalcraft.infusion.InfusionHelper;
import sirttas.elementalcraft.recipe.instrument.infusion.AbstractInfusionRecipe;

public class ToolInfusionRecipe
extends AbstractInfusionRecipe {
    public ToolInfusionRecipe() {
        super(null, ElementType.NONE);
    }

    @Override
    public boolean matches(TileInfuser instrument) {
        ItemStack stack = instrument.getItem();
        if (super.matches(instrument) && InfusionHelper.isInfusable(stack)) {
            return InfusionHelper.getInfusion(stack) != instrument.getTankElementType();
        }
        return false;
    }

    @Override
    public int getElementPerTick() {
        return 10;
    }

    @Override
    public int getDuration() {
        return 100;
    }

    @Override
    public ItemStack getCraftingResult(TileInfuser instrument) {
        ItemStack stack = instrument.getItem();
        InfusionHelper.setInfusion(stack, instrument.getTankElementType());
        return stack;
    }

    @Deprecated
    public ItemStack func_77571_b() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public IRecipeSerializer<?> func_199559_b() {
        throw new UnsupportedOperationException();
    }

    public ToolInfusionRecipe with(ElementType type) {
        this.elementType = type;
        return this;
    }
}

