/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.earth;

import com.google.common.collect.Multimap;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.spell.Spell;

public class SpellGavelFall
extends Spell {
    public static final String NAME = "gravelfall";

    public SpellGavelFall() {
        super(Spell.Properties.create(Spell.Type.COMBAT).elementType(ElementType.EARTH).cooldown((Integer)ECConfig.CONFIG.gravelFallCooldown.get()).consumeAmount((Integer)ECConfig.CONFIG.gravelFallConsumeAmount.get()));
    }

    private void spawn(World world, BlockPos pos) {
        FallingBlockEntity entity = new FallingBlockEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, Blocks.field_150351_n.func_176223_P());
        entity.field_145812_b = 1;
        entity.func_145806_a(true);
        world.func_217376_c((Entity)entity);
    }

    private void checkAndSpawn(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            this.spawn(world, pos);
        }
    }

    private ActionResultType spawnGravel(Entity sender, BlockPos pos) {
        World world = sender.func_130014_f_();
        this.checkAndSpawn(world, pos.func_177981_b(4));
        this.checkAndSpawn(world, pos.func_177981_b(5));
        this.checkAndSpawn(world, pos.func_177981_b(6));
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType castOnBlock(Entity sender, BlockPos target) {
        return this.spawnGravel(sender, target);
    }

    @Override
    public ActionResultType castOnEntity(Entity sender, Entity target) {
        return this.spawnGravel(sender, target.func_180425_c());
    }

    @Override
    public boolean consume(Entity sender) {
        boolean value = this.consume(sender, (IItemProvider)Blocks.field_150351_n, 3);
        return super.consume(sender) && value;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(equipmentSlot);
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)PlayerEntity.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(REACH_DISTANCE_MODIFIER, "Reach distance modifier", 5.0, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

