/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.dimension.boss;

import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.IBiomeProviderSettings;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NetherGenSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.common.util.ITeleporter;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.world.biome.ECBiomes;
import sirttas.elementalcraft.world.dimension.ECDimensions;
import sirttas.elementalcraft.world.dimension.boss.ECBossFightManager;

public class BossDimension
extends Dimension {
    public static final String NAME = "bossdimension";
    private static final int SPAWN_HEIGHT = 70;
    public static final ITeleporter TELEPORTER = new ITeleporter(){

        public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            Entity repositionedEntity = repositionEntity.apply(false);
            BlockPos newPos = BlockPos.field_177992_a;
            if (destWorld.func_201675_m().func_186058_p() == BossDimension.getDimensionType()) {
                ECBossFightManager fightManager = ((BossDimension)destWorld.func_201675_m()).getBossFightManager();
                newPos = destWorld.func_201675_m().func_206921_a(0, 0, false);
                if (repositionedEntity instanceof ServerPlayerEntity) {
                    fightManager.addPlayer((ServerPlayerEntity)repositionedEntity);
                }
                fightManager.init(ElementType.EARTH);
            } else if (destWorld.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
                newPos = destWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, destWorld.func_175694_M());
            }
            repositionedEntity.func_70634_a((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p());
            return repositionedEntity;
        }
    };
    private final ECBossFightManager bossFightManager;

    public static DimensionType getDimensionType() {
        return DimensionManager.registerOrGetDimension((ResourceLocation)ElementalCraft.createRL(NAME), (ModDimension)ECDimensions.bossDimension, null, (boolean)true);
    }

    public BossDimension(World world, DimensionType type) {
        super(world, type, 0.0f);
        this.bossFightManager = world instanceof ServerWorld ? new ECBossFightManager((ServerWorld)world) : null;
    }

    public ChunkGenerator<?> func_186060_c() {
        NetherGenSettings settings = (NetherGenSettings)ChunkGeneratorType.field_206912_c.func_205483_a();
        settings.func_214969_a(Blocks.field_150348_b.func_176223_P());
        settings.func_214970_b(Blocks.field_150353_l.func_176223_P());
        return ChunkGeneratorType.field_206912_c.create(this.field_76579_a, BiomeProviderType.field_205461_c.func_205457_a((IBiomeProviderSettings)((SingleBiomeProviderSettings)BiomeProviderType.field_205461_c.func_226840_a_(this.field_76579_a.func_72912_H())).func_205436_a(ECBiomes.EARTH)), (GenerationSettings)settings);
    }

    public void func_186059_r() {
        if (this.bossFightManager != null) {
            this.bossFightManager.tick();
        }
    }

    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        return this.func_206921_a(chunkPosIn.field_77276_a * 16, chunkPosIn.field_77275_b * 16, checkValid);
    }

    public BlockPos func_206921_a(int x, int z, boolean checkValid) {
        BlockPos.Mutable pos = new BlockPos.Mutable(x, 70, z);
        for (int i = 0; i < 70; ++i) {
            pos.func_181079_c(x, 70 - i, z);
            if (!this.field_76579_a.func_175623_d((BlockPos)pos) || this.field_76579_a.func_175623_d(pos.func_177982_a(x, -1, z))) continue;
            return pos;
        }
        return pos;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.0f;
    }

    public boolean func_76569_d() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        return new Vec3d((double)(f1 *= f * 0.94f + 0.06f), (double)(f2 *= f * 0.94f + 0.06f), (double)(f3 *= f * 0.91f + 0.09f));
    }

    public boolean func_76567_e() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public ECBossFightManager getBossFightManager() {
        return this.bossFightManager;
    }
}

