/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.dimension.boss;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.entity.boss.ECBossEntity;
import sirttas.elementalcraft.entity.boss.earthgolem.EarthGolemEntity;
import sirttas.elementalcraft.world.dimension.boss.BossDimension;

public class ECBossFightManager {
    private final ServerWorld world;
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo((ITextComponent)new StringTextComponent(""), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS).func_186743_c(true);
    private ElementType type;
    private ECBossEntity boss;

    public ECBossFightManager(ServerWorld world) {
        this.world = world;
        this.boss = null;
        this.type = ElementType.NONE;
    }

    public void tick() {
        this.world.func_217482_a(EntityType.field_200765_E, (Predicate)Predicates.alwaysTrue()).forEach(Entity::func_70106_y);
        if (!this.isBossAlive()) {
            if (this.boss != null) {
                // empty if block
            }
            this.boss = null;
            this.world.func_217490_a(EntityPredicates.field_94557_a).forEach(this::removePlayer);
        }
    }

    private boolean isBossAlive() {
        return this.boss != null && this.boss.func_70089_S();
    }

    public void addPlayer(ServerPlayerEntity player) {
        this.bossInfo.func_186760_a(player);
    }

    public void removePlayer(ServerPlayerEntity player) {
        this.bossInfo.func_186761_b(player);
        player.changeDimension(DimensionType.field_223227_a_, BossDimension.TELEPORTER);
    }

    public void init(ElementType type) {
        this.setElementType(type);
        this.buildArena();
        this.spawnBoss();
    }

    private void buildArena() {
    }

    private void spawnBoss() {
        BlockPos pos = this.world.field_73011_w.func_206921_a(0, 50, false);
        pos = pos.equals((Object)BlockPos.field_177992_a) ? this.world.field_73011_w.func_206921_a(50, 0, false) : pos;
        this.boss = (ECBossEntity)EarthGolemEntity.TYPE.func_200721_a((World)this.world);
        this.boss.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.bossInfo.func_186739_a(this.boss.func_145748_c_());
        this.world.func_217376_c((Entity)this.boss);
    }

    public void setElementType(ElementType type) {
        this.type = type;
    }
}

