/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.registry.RegistryHelper;
import sirttas.elementalcraft.world.feature.SourceFeature;
import sirttas.elementalcraft.world.feature.structure.SourceAltarStructure;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECFeatures {
    @ObjectHolder(value="elementalcraft:source")
    public static Feature<NoFeatureConfig> source;
    @ObjectHolder(value="elementalcraft:source_altar")
    public static Structure<NoFeatureConfig> sourceAltar;

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry r = event.getRegistry();
        RegistryHelper.register(r, new SourceFeature(), "source");
        RegistryHelper.register(r, new SourceAltarStructure(), "source_altar");
        IStructurePieceType.func_214750_a((IStructurePieceType)SourceAltarStructure.PIECE_TYPE, (String)"elementalcraft:source_altar");
    }

    public static void addToWorldgen() {
        if (Boolean.FALSE.equals(ECConfig.CONFIG.disableWorldGen.get())) {
            for (Biome biome : ForgeRegistries.BIOMES) {
                Biome.Category category = biome.func_201856_r();
                if (category.equals((Object)Biome.Category.THEEND) || category.equals((Object)Biome.Category.NETHER)) continue;
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ECBlocks.crystalOre.func_176223_P(), 9)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 64))));
                biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, source.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215023_i.func_227446_a_((IPlacementConfig)new ChanceConfig(((Integer)ECConfig.CONFIG.sourceSpawnChance.get()).intValue()))));
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, sourceAltar.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                if (category.equals((Object)Biome.Category.OCEAN) || category.equals((Object)Biome.Category.BEACH) || category.equals((Object)Biome.Category.RIVER) || category.equals((Object)Biome.Category.SWAMP)) continue;
                biome.func_226711_a_(sourceAltar.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        }
    }
}

