/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature.structure;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.property.ECProperties;

public class SourceAltarStructure
extends ScatteredStructure<NoFeatureConfig> {
    public static final String NAME = "source_altar";
    public static final IStructurePieceType PIECE_TYPE = Piece::new;
    private static final ResourceLocation SMALL = ElementalCraft.createRL("altar/small");
    private static final ResourceLocation MEDIUM = ElementalCraft.createRL("altar/medium");

    public SourceAltarStructure() {
        super(NoFeatureConfig::func_214639_a);
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return NAME;
    }

    public int func_202367_b() {
        return 3;
    }

    protected int func_202382_c() {
        return 4847339;
    }

    protected int func_204030_a(ChunkGenerator<?> chunkGenerator) {
        return (Integer)ECConfig.CONFIG.sourceAltarDistance.get();
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation templateName;
        private ElementType elementType;

        public Piece(TemplateManager templateManager, ResourceLocation templateName, ElementType elementType, BlockPos pos) {
            super(PIECE_TYPE, 0);
            this.field_186178_c = pos;
            this.templateName = templateName;
            this.elementType = elementType;
            this.initTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbt) {
            super(PIECE_TYPE, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.elementType = ElementType.byName(nbt.func_74779_i("ElementType"));
            this.initTemplate(templateManager);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
            tagCompound.func_74778_a("ElementType", this.elementType.func_176610_l());
        }

        private void initTemplate(TemplateManager templateManager) {
            this.func_186173_a(templateManager.func_200220_a(this.templateName), this.field_186178_c, new PlacementSettings().func_186214_a(Mirror.NONE).func_207665_a(new BlockPos(1, 0, 1)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a));
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> chunkGeneratorIn, Random randomIn, MutableBoundingBox mutableBoundingBoxIn, ChunkPos chunkPosIn) {
            this.field_186178_c = this.field_186178_c.func_177982_a(0, worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.field_186178_c.func_177958_n(), this.field_186178_c.func_177952_p()) - 1, 0);
            return super.func_225577_a_(worldIn, chunkGeneratorIn, randomIn, mutableBoundingBoxIn, chunkPosIn);
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chest".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, ElementalCraft.createRL("chests/altar/small_" + this.elementType.func_176610_l()), null);
                worldIn.func_195592_c(pos, Blocks.field_150486_ae);
            } else if ("source".equals(function)) {
                worldIn.func_180501_a(pos, (BlockState)ECBlocks.source.func_176223_P().func_206870_a(ECProperties.ELEMENT_TYPE, (Comparable)((Object)this.elementType)), 3);
            }
        }
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int x, int y, MutableBoundingBox mutableboundingbox, int ref, long seed) {
            super(structure, x, y, mutableboundingbox, ref, seed);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            this.field_75075_a.add(new Piece(templateManagerIn, this.field_214631_d.nextInt(8) < 6 ? SMALL : MEDIUM, ElementType.random((Random)this.field_214631_d), new BlockPos(chunkX * 16, 0, chunkZ * 16)));
            this.func_202500_a();
        }
    }
}

