/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import sirttas.elementalcraft.property.ECProperties;

public enum ElementType implements IStringSerializable
{
    NONE(0, 0, 0, "none"),
    WATER(43, 173, 255, "water"),
    FIRE(247, 107, 27, "fire"),
    EARTH(76, 133, 102, "earth"),
    AIR(238, 255, 219, "air");

    public static final Codec<ElementType> CODEC;
    private final float r;
    private final float g;
    private final float b;
    private final int color;
    private final String name;

    private ElementType(int r, int g, int b, String name) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.name = name;
        this.color = r << 16 | g << 8 | b;
    }

    public float getRed() {
        return this.r;
    }

    public float getGreen() {
        return this.g;
    }

    public float getBlue() {
        return this.b;
    }

    public int getColor() {
        return this == NONE ? -1 : this.color;
    }

    public static ElementType random() {
        return ElementType.random(new Random());
    }

    public static ElementType random(Random rand) {
        int random = rand.nextInt(4);
        switch (random) {
            case 0: {
                return WATER;
            }
            case 1: {
                return FIRE;
            }
            case 2: {
                return EARTH;
            }
            case 3: {
                return AIR;
            }
        }
        return NONE;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    public static ElementType byName(String name) {
        for (ElementType elementType : ElementType.values()) {
            if (!elementType.name.equals(name)) continue;
            return elementType;
        }
        return NONE;
    }

    public static ElementType getElementType(BlockState state) {
        return (ElementType)((Object)state.func_177229_b(ECProperties.ELEMENT_TYPE));
    }

    public String getTranslationKey() {
        return "element.elementalcraft." + this.func_176610_l();
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    static {
        CODEC = new PrimitiveCodec<ElementType>(){

            public <T> DataResult<ElementType> read(DynamicOps<T> ops, T input) {
                return ops.getStringValue(input).map(ElementType::byName);
            }

            public <T> T write(DynamicOps<T> ops, ElementType value) {
                return (T)ops.createString(value.toString());
            }

            public String toString() {
                return "ElementType";
            }
        };
    }
}

