/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import sirttas.elementalcraft.block.BlockECTileProvider;
import sirttas.elementalcraft.block.tile.IForcableSync;
import sirttas.elementalcraft.inventory.ECInventoryHelper;

public abstract class BlockECContainer
extends BlockECTileProvider {
    public BlockECContainer() {
    }

    public BlockECContainer(AbstractBlock.Properties properties) {
        super(properties);
    }

    private boolean canInsertStack(IItemHandler inventory, ItemStack stack, ItemStack heldItem, int slot) {
        return stack.func_77969_a(heldItem) && stack.func_190916_E() < stack.func_77976_d() && stack.func_190916_E() < inventory.getSlotLimit(slot);
    }

    private ActionResultType onSlotActivatedUnsync(IItemHandler inventory, PlayerEntity player, ItemStack heldItem, int slot) {
        ItemStack stack = inventory.getStackInSlot(slot);
        World world = player.func_130014_f_();
        if (heldItem.func_190926_b() || player.func_225608_bj_() || !stack.func_190926_b() && !this.canInsertStack(inventory, stack, heldItem, slot)) {
            if (!stack.func_190926_b()) {
                ItemStack extracted = inventory.extractItem(slot, stack.func_190916_E(), false);
                if (!world.func_201670_d()) {
                    world.func_217376_c((Entity)new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_() + 0.25, player.func_226281_cx_(), extracted));
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (stack.func_190926_b() && inventory.isItemValid(slot, heldItem)) {
            int size = Math.min(heldItem.func_190916_E(), inventory.getSlotLimit(slot));
            stack = heldItem.func_77946_l();
            stack.func_190920_e(size);
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(size);
            }
            inventory.insertItem(slot, stack, false);
            return ActionResultType.SUCCESS;
        }
        if (!stack.func_190926_b() && this.canInsertStack(inventory, stack, heldItem, slot)) {
            int size = Math.min(heldItem.func_190916_E(), inventory.getSlotLimit(slot) - stack.func_190916_E());
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(size);
            }
            stack.func_190917_f(size);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected ActionResultType onSlotActivated(IItemHandler inventory, PlayerEntity player, ItemStack heldItem, int slot) {
        ActionResultType ret = this.onSlotActivatedUnsync(inventory, player, heldItem, slot);
        if (ret.func_226246_a_() && inventory instanceof IForcableSync) {
            ((IForcableSync)inventory).forceSync();
        }
        return ret;
    }

    protected ActionResultType onSingleSlotActivated(World world, BlockPos pos, PlayerEntity player, Hand hand) {
        IItemHandler inv = ECInventoryHelper.getItemHandlerAt((IBlockReader)world, pos, null);
        if (inv != null) {
            return this.onSlotActivated(inv, player, player.func_184586_b(hand), 0);
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            IItemHandler inv = ECInventoryHelper.getItemHandlerAt((IBlockReader)worldIn, pos, null);
            for (int i = 0; i < inv.getSlots(); ++i) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)inv.getStackInSlot(i));
            }
            worldIn.func_175666_e(pos, (Block)this);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

