/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument;

import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import sirttas.elementalcraft.block.instrument.IInstrument;
import sirttas.elementalcraft.block.retriever.BlockRetriever;
import sirttas.elementalcraft.block.tank.TileTank;
import sirttas.elementalcraft.block.tile.TileECContainer;
import sirttas.elementalcraft.recipe.instrument.IInstrumentRecipe;

public abstract class TileInstrument
extends TileECContainer
implements IInstrument {
    protected float progress = 0.0f;
    private IInstrumentRecipe<IInstrument> recipe;
    protected int outputSlot = 0;

    public TileInstrument(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public boolean isRecipeAvailable() {
        if (this.recipe != null && this.recipe.matches(this)) {
            return true;
        }
        if (this.recipe != null) {
            this.forceSync();
        }
        this.recipe = this.lookupRecipe();
        return this.recipe != null;
    }

    protected abstract <T extends IInstrument> IInstrumentRecipe<T> lookupRecipe();

    private void sendOutputToRetriever() {
        IInventory inventory = this.getInventory();
        for (Direction direction : Direction.values()) {
            BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction));
            if (!(blockState.func_177230_c() instanceof BlockRetriever) || blockState.func_177229_b((Property)BlockRetriever.SOURCE) != direction.func_176734_d()) continue;
            ItemStack output = BlockRetriever.retrive(blockState, (IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(direction), inventory.func_70301_a(this.outputSlot));
            inventory.func_70299_a(this.outputSlot, output);
            if (!output.func_190926_b()) continue;
            return;
        }
    }

    @Override
    public void process() {
        this.recipe.process(this);
        this.recipe = null;
        this.sendOutputToRetriever();
        this.forceSync();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.makeProgress();
    }

    protected void makeProgress() {
        TileTank tank = this.getTank();
        if (this.recipe != null && this.progress >= (float)this.recipe.getDuration()) {
            this.process();
            this.progress = 0.0f;
        } else if (this.isRecipeAvailable() && tank != null && this.canProgress() && tank.extractElement(this.recipe.getElementPerTick(), this.recipe.getElementType(), true) == this.recipe.getElementPerTick()) {
            tank.extractElement(this.recipe.getElementPerTick(), this.recipe.getElementType(), false);
            this.progress += 1.0f;
        } else {
            this.progress = 0.0f;
        }
    }

    @Override
    public boolean isRunning() {
        return this.progress > 0.0f;
    }

    @Override
    public boolean canProgress() {
        return true;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT cmp) {
        super.func_189515_b(cmp);
        cmp.func_74776_a("progress", this.progress);
        return cmp;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT cmp) {
        super.func_230337_a_(state, cmp);
        this.progress = cmp.func_74760_g("progress");
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public void func_174888_l() {
        super.func_174888_l();
        this.recipe = null;
        this.progress = 0.0f;
    }
}

